package server.util;

/**
 * Diese Klasse dient zur Kapselung von zwei Objekten. Der Typ beider Objekte kann festgelegt werden.
 * Der Wert des Tupels kann nachtraeglich veraendert werden.
 *
 * @param <T> Typ des ersten Objekts.
 * @param <U> Typ des zweiten Objekts.
 */
public class Tuple<T1, T2> {
	
	/**
	 * Erstes Objekt.
	 */
	private T1 elem1;
	
	/**
	 * Zweites Objekt.
	 */
	private T2 elem2;
	
	/**
	 * Erzeugt ein neues Tupel mit zwei Elementen.
	 * 
	 * @param elem1 Erstes Element.
	 * @param elem2 Zweites Element.
	 */
	public Tuple(T1 elem1, T2 elem2) {
		this.elem1 = elem1;
		this.elem2 = elem2;
	}
	
	/**
	 * Gibt das erste Element zurueck.
	 * 
	 * @return Das erste Element des Tupels.
	 */
	public T1 getFirstElement() {
		return elem1;
	}
	
	/**
	 * Gibt das zweite Element zurueck.
	 * 
	 * @return Das zweite Element des Tupels.
	 */
	public T2 getSecondElement() {
		return elem2;
	}
	
	/**
	 * Setzt das erste Element.
	 * 
	 * @param elem1 neues erstes Element
	 */
	public void setFirstElement(T1 elem1) {
		this.elem1 = elem1;
	}
	
	/**
	 * Setzt das zweite Element.
	 * 
	 * @param elem1 neues zweite Element
	 */
	public void setSecondElement(T2 elem2) {
		this.elem2 = elem2;
	}
	
	/**
	 * Gibt beide Elemente als String im Format "(<ErstesElement>, <ZweitesElement>)" aus.
	 */
	public String toString() {
		return "("+this.getFirstElement().toString()+", "+this.getSecondElement()+")";
	}
}
