package server.parser.node;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

import exception.UnsupportedFormulaException;

import server.parser.Formatter.FormulaFormatter;


/**
 * Knoten für Formel : NOT F
 * */
public class NegationNode extends Node {
	private static final long serialVersionUID = 2282067758449213084L;

	public NegationNode(Node formula) {
		this.addChild(formula);
	}
	
	public boolean isNegationNode() {
		return true;
	}
	
	/**
	 * Liefert die Formel zurueck, die hinter dem Negationszeichen steht.
	 * 
	 * @return Negierter Teil der Formel.
	 */
	public Node getNegatedFormula() {
		return getChild(0);
	}
	
	public void setNegatedFormula(Node formula) {
		ArrayList<Node> children = new ArrayList<Node>();
		children.add( formula );
		this.replaceChildren(children);
	}
	
	public String toString(FormulaFormatter formulaformatter) {
		StringBuilder builder = new StringBuilder();
		builder.append(formulaformatter.getBeforeNegation());
		builder.append(SPACE);
		builder.append(getNegatedFormula().toString(formulaformatter));
		builder.append(formulaformatter.getAfterNegation());
		return builder.toString();
	}
	
	@Override
	public boolean isElementaryFormula() {
		return getNegatedFormula().isElementaryFormula();
	}
	
	@Override
	public Set<String> rr() {
		Set<String> retVal = null;
		Set<String> subRR = getNegatedFormula().rr();
		if (subRR != null) {
			retVal = new HashSet<String>();
		} else {
			retVal = null;
		}
		return retVal;
	}
	
	@Override
	protected void pushNegations( boolean foundNegation, boolean skipNegatedExistentialQuantifiers ) throws UnsupportedFormulaException {
		Node child = this.getNegatedFormula();
		
		if( foundNegation ) {
			// doppelte Negation (vorher gefunden und aktueller Knoten) -> Negation loeschen
			this.getParent().replaceChild(this, child);
			foundNegation = false;
		}
		else if( child.isAtomPredicateNode() ) {
			return;
		}
		else if( skipNegatedExistentialQuantifiers && child.isExistentialQuantifiedNode() ) {
			// Negation _nicht_ loeschen (Anwendung findet dies u.a. bei der SRNF-Umformung)
			foundNegation = false;
		}
		else {
			// Negation loeschen und in Unterformel hineinziehen
			this.getParent().replaceChild(this, child);
			foundNegation = true;
		}
		
		// Rekursiver Aufruf fuer das Kind.
		child.pushNegations(foundNegation, skipNegatedExistentialQuantifiers);
	}
}
