package server.parser.node;

import server.parser.Formatter.FormulaFormatter;


public class EquivalenceNode extends ConnectorNode {
	private static final long serialVersionUID = -1999442886770867203L;

	public EquivalenceNode() {
	}

	@Override
	public boolean isEquivalenceNode() {
		return true;
	}

	@Override
	protected String getJunctor(FormulaFormatter formatter) {
		return formatter.getEquivalence();
	}
	
	@Override
	public void transformEquivalence() {
		// Rekursiver Aufruf.
		this.getChild(0).transformEquivalence();
		this.getChild(1).transformEquivalence();
		
		// Kinder auslesen (evtl. aufgrund des rekursiven Aufrufs von urspruenglichen Kindern verschieden)
		Node a = this.getChild(0);
		Node b = this.getChild(1);
		
		DisjunctorNode or1 = new DisjunctorNode();
		or1.addOperand( new NegationNode(a) );
		or1.addOperand( b );
		
		DisjunctorNode or2 = new DisjunctorNode();
		// a und b clonen, da sie bereits im Syntax-Baum von or1 enthalten sind
		or2.addOperand( new NegationNode(b.clone()) );
		or2.addOperand( a.clone() );
		
		ConjunctorNode and = new ConjunctorNode();
		and.addOperand( or1 );
		and.addOperand( or2 );
		
		this.getParent().replaceChild(this, and);
	}
}
