package server.database.schema.maintenance;

import exception.DatabaseException;
import server.database.schema.SchemaColumn;
import server.database.schema.TableSchema;

/**
 * Tabellen-Schema fuer den unflexiblen statischen SignatureCensor.
 * 
 * Achtung: Fuer eine korrekte Funktionsweise des SignatureCensors muss zusaetzlich zur 
 * Generierung des Schemas auch die sql-Datei 'staticSignatureCensorExperimentCreate.sql', 
 * die u.a. die Trigger fuer den SignatureCensor enthaelt, in der Datenbank ausgefuehrt 
 * werden.
 */
public abstract class SignaturesUnflexibleSignaturesSchema extends TableSchema {
	
	public final static SchemaColumn SIG_ID = new SchemaColumn("SIG_ID", "NUMBER(7,0)", true, true);
	public final static SchemaColumn USER_ID = new SchemaColumn("USER_ID", "NUMBER(7,0)", true, true);
	public final static SchemaColumn FLAG_OLD = new SchemaColumn("FLAG_OLD", "NUMBER(1,0)", true);
	public final static SchemaColumn FLAG_IMPL = new SchemaColumn("FLAG_IMPL", "NUMBER(1,0)", true);
	
	public final static String TABLE_PREFIX = "SIGS_SIG_";
	
	public SignaturesUnflexibleSignaturesSchema(String name, SchemaColumn... columns) throws DatabaseException {
		super(name, columns);
	}
}
