package server.database.schema.maintenance;

import exception.DatabaseException;
import server.database.schema.SchemaColumn;

/**
 * Tabellen-Schema fuer den unflexiblen statischen SignatureCensor.
 * 
 * Achtung: Fuer eine korrekte Funktionsweise des SignatureCensors muss zusaetzlich zur 
 * Generierung des Schemas auch die sql-Datei 'staticSignatureCensorExperimentCreate.sql', 
 * die u.a. die Trigger fuer den SignatureCensor enthaelt, in der Datenbank ausgefuehrt 
 * werden.
 */
public class SignaturesUnflexibleQueryKrankheitSchema extends SignaturesUnflexibleQuerySchema {
	
	public final static SchemaColumn SYMPTOM = new SchemaColumn("SYMPTOM", "VARCHAR2(400 BYTE)", true);
	public final static SchemaColumn DIAGNOSIS = new SchemaColumn("DIAGNOSIS", "VARCHAR2(400 BYTE)", true);
	public final static SchemaColumn PATIENT = new SchemaColumn("PATIENT", "VARCHAR2(400 BYTE)", true);
	
	public SignaturesUnflexibleQueryKrankheitSchema() throws DatabaseException {
		super(TABLE_PREFIX + "SIG_KRANKHEIT", USER_ID, REACTION, SYMPTOM, DIAGNOSIS, PATIENT, PROCESSING_TIME);
	}
}
