package server.database.schema.maintenance;

import server.database.schema.SchemaColumn;
import server.database.schema.TableSchema;
import exception.DatabaseException;

/**
 * Tabellen-Schema fuer das Experiment zum statischen SignatureCensor.
 * 
 * Achtung: Fuer eine korrekte Funktionsweise des SignatureCensors muss zusaetzlich zur 
 * Generierung des Schemas auch die sql-Datei 'staticSignatureCensorExperimentCreate.sql', 
 * die u.a. die Trigger fuer den SignatureCensor enthaelt, in der Datenbank ausgefuehrt 
 * werden.
 */
public class SignaturesExperimentEvaluationSchema extends TableSchema {
	
	public final static String TABLE_NAME = "SIGS_EXPERIMENT_EVAL";
	public final static SchemaColumn RUN_ID = new SchemaColumn("RUN_ID", "NUMBER(7,0)", true, true);
	public final static SchemaColumn QUERY_ID = new SchemaColumn("QUERY_ID", "NUMBER(7,0)", true, true);
	public final static SchemaColumn QUERY = new SchemaColumn("QUERY", "VARCHAR2(4000 BYTE)", true);
	public final static SchemaColumn RESULT = new SchemaColumn("RESULT", "VARCHAR2(20 BYTE)", true);
	public final static SchemaColumn PROCESSING_TIME = new SchemaColumn("PROCESSING_TIME", "NUMBER(7,0)", true);
	public final static SchemaColumn DATABASE_PROCESSING_TIME = new SchemaColumn("DATABASE_PROCESSING_TIME", "NUMBER(7,0)", true);
	
	public SignaturesExperimentEvaluationSchema() throws DatabaseException {
		super(TABLE_NAME, RUN_ID, QUERY_ID, QUERY, RESULT, PROCESSING_TIME, DATABASE_PROCESSING_TIME);
	}
}
