package server.database.schema.app;

import server.data.ConfidentialityPolicy;
import server.data.PriorUser;
import server.data.User;
import server.database.NewMaintenanceDatabase;
import server.database.schema.app.dict.GeburtsdatenDictionary;
import server.database.schema.app.dict.MatrikelnummernDictionary;
import server.database.schema.app.dict.NotenDictionary;
import server.database.schema.app.dict.StudentenDictionary;
import server.database.schema.app.dict.VorlesungenDictionary;
import server.database.schema.maintenance.MaintenanceDatabaseSchema;
import server.database.sql.SQLDatabase;
import server.database.sql.SQLExpression;
import server.parser.Formula;
import exception.DatabaseException;
import exception.ParserException;
import exception.UnknownUserException;
import communication.CqeType;
import static org.junit.Assert.fail;


public class StudentenExample extends MaintenanceDatabaseSchema {
	
	public final StudentenTableSchema studenten;
	public final NotenTableSchema noten;
	private int LYING_ID = 1;
	private int REFUSAL_ID = 2;
	private int COMBINED_ID = 3;
	public final StudentenDictionary studentenDict;
	public final MatrikelnummernDictionary matrikelnrDict;
	public final GeburtsdatenDictionary birthdayDict;
	public final NotenDictionary notenDict;
	public final VorlesungenDictionary vorlesungenDict;

	public StudentenExample() throws DatabaseException {
		super("Vorführbeispiel: Studenten (deutsch)");
		
		this.studenten = new StudentenTableSchema();
		this.noten = new NotenTableSchema();
		
		this.appTables.add(this.studenten);
		this.appTables.add(this.noten);
		
		this.studentenDict = new StudentenDictionary();
		this.matrikelnrDict = new MatrikelnummernDictionary();
		this.birthdayDict = new GeburtsdatenDictionary();
		this.notenDict = new NotenDictionary();
		this.vorlesungenDict = new VorlesungenDictionary();
		
		this.maintenanceTables.add( this.studentenDict );
		this.maintenanceTables.add( this.matrikelnrDict );
		this.maintenanceTables.add( this.birthdayDict );
		this.maintenanceTables.add( this.notenDict );
		this.maintenanceTables.add( this.vorlesungenDict );
	}
	
	@Override
	public void fillAppDBWithContents(SQLDatabase db) throws DatabaseException {
		this.fillStudenten(db);
		this.fillNoten(db);
	}
	
	private void fillStudenten(SQLDatabase db) throws DatabaseException {
		SQLExpression sql;
		
		sql = db.sql();
		sql.set( StudentenTableSchema.MATRIKELNR, "123456" ).set( StudentenTableSchema.STUDENT, "Mark Zuckerberg" ).set( StudentenTableSchema.GEBURTSTAG, "14.05.1984" );	
		db.insert(this.studenten);
		
		sql = db.sql();
		sql.set( StudentenTableSchema.MATRIKELNR, "111111" ).set( StudentenTableSchema.STUDENT, "Bill Gates" ).set( StudentenTableSchema.GEBURTSTAG, "28.10.1955" );	
		db.insert(this.studenten);
		
		sql = db.sql();
		sql.set( StudentenTableSchema.MATRIKELNR, "169681" ).set( StudentenTableSchema.STUDENT, "Tim Berners Lee" ).set( StudentenTableSchema.GEBURTSTAG, "08.06.1955" );	
		db.insert(this.studenten);
		
		sql = db.sql();
		sql.set( StudentenTableSchema.MATRIKELNR, "161163" ).set( StudentenTableSchema.STUDENT, "Steve Ballmer" ).set( StudentenTableSchema.GEBURTSTAG, "24.03.1956" );	
		db.insert(this.studenten);
		
		sql = db.sql();
		sql.set( StudentenTableSchema.MATRIKELNR, "167588" ).set( StudentenTableSchema.STUDENT, "Linus Torvalds" ).set( StudentenTableSchema.GEBURTSTAG, "28.12.1969" );	
		db.insert(this.studenten);
		
		sql = db.sql();
		sql.set( StudentenTableSchema.MATRIKELNR, "175057" ).set( StudentenTableSchema.STUDENT, "Alan Turing" ).set( StudentenTableSchema.GEBURTSTAG, "23.06.1912" );	
		db.insert(this.studenten);
		
		sql = db.sql();
		sql.set( StudentenTableSchema.MATRIKELNR, "156868" ).set( StudentenTableSchema.STUDENT, "Stephen Cook" ).set( StudentenTableSchema.GEBURTSTAG, "14.12.1939" );	
		db.insert(this.studenten);
		
		sql = db.sql();
		sql.set( StudentenTableSchema.MATRIKELNR, "192641" ).set( StudentenTableSchema.STUDENT, "Jacques Herbrand" ).set( StudentenTableSchema.GEBURTSTAG, "12.02.1908" );	
		db.insert(this.studenten);
		
		sql = db.sql();
		sql.set( StudentenTableSchema.MATRIKELNR, "181427" ).set( StudentenTableSchema.STUDENT, "Larry Page" ).set( StudentenTableSchema.GEBURTSTAG, "26.03.1973" );	
		db.insert(this.studenten);
		
		sql = db.sql();
		sql.set( StudentenTableSchema.MATRIKELNR, "146248" ).set( StudentenTableSchema.STUDENT, "Paul Otellini" ).set( StudentenTableSchema.GEBURTSTAG, "12.10.1950" );	
		db.insert(this.studenten);
		
		sql = db.sql();
		sql.set( StudentenTableSchema.MATRIKELNR, "119842" ).set( StudentenTableSchema.STUDENT, "Lawrence Ellison" ).set( StudentenTableSchema.GEBURTSTAG, "17.08.1944" );	
		db.insert(this.studenten);
		
	}

	private void fillNoten(SQLDatabase db) throws DatabaseException {
		SQLExpression sql;
		
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "123456" ).set( NotenTableSchema.VORLESUNG, "Datenschutz").set(NotenTableSchema.NOTE, "5.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "123456" ).set( NotenTableSchema.VORLESUNG, "Verteilte Systeme").set(NotenTableSchema.NOTE, "1.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "123456" ).set( NotenTableSchema.VORLESUNG, "Informationssysteme").set(NotenTableSchema.NOTE, "1.3");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "123456" ).set( NotenTableSchema.VORLESUNG, "Social Skills").set(NotenTableSchema.NOTE, "5.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "111111" ).set( NotenTableSchema.VORLESUNG, "Betriebssysteme").set(NotenTableSchema.NOTE, "1.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "111111" ).set( NotenTableSchema.VORLESUNG, "Eingebettete Systeme").set(NotenTableSchema.NOTE, "1.7");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "169681" ).set( NotenTableSchema.VORLESUNG, "Netzwerktechnik").set(NotenTableSchema.NOTE, "1.3");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "169681" ).set( NotenTableSchema.VORLESUNG, "Verteilte Systeme").set(NotenTableSchema.NOTE, "1.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "169681" ).set( NotenTableSchema.VORLESUNG, "Theoretische Informatik").set(NotenTableSchema.NOTE, "3.7");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "161163" ).set( NotenTableSchema.VORLESUNG, "Betriebssysteme").set(NotenTableSchema.NOTE, "2.7");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "161163" ).set( NotenTableSchema.VORLESUNG, "Logik").set(NotenTableSchema.NOTE, "5.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "167588" ).set( NotenTableSchema.VORLESUNG, "Betriebssysteme").set(NotenTableSchema.NOTE, "1.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "167588" ).set( NotenTableSchema.VORLESUNG, "Betriebssystembau").set(NotenTableSchema.NOTE, "1.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "175057" ).set( NotenTableSchema.VORLESUNG, "Theoretische Informatik").set(NotenTableSchema.NOTE, "1.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "175057" ).set( NotenTableSchema.VORLESUNG, "Logik").set(NotenTableSchema.NOTE, "1.3");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "175057" ).set( NotenTableSchema.VORLESUNG, "Komplexitätstheorie").set(NotenTableSchema.NOTE, "1.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "175057" ).set( NotenTableSchema.VORLESUNG, "Informationssysteme").set(NotenTableSchema.NOTE, "4.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "175057" ).set( NotenTableSchema.VORLESUNG, "Compilerbau").set(NotenTableSchema.NOTE, "5.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "156868" ).set( NotenTableSchema.VORLESUNG, "Komplexitätstheorie").set(NotenTableSchema.NOTE, "1.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "156868" ).set( NotenTableSchema.VORLESUNG, "Netzwerktechnik").set(NotenTableSchema.NOTE, "5.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "156868" ).set( NotenTableSchema.VORLESUNG, "Verteilte Systeme").set(NotenTableSchema.NOTE, "3.3");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "192641" ).set( NotenTableSchema.VORLESUNG, "Logik").set(NotenTableSchema.NOTE, "1.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "192641" ).set( NotenTableSchema.VORLESUNG, "Mathematik für Informatiker").set(NotenTableSchema.NOTE, "1.3");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "192641" ).set( NotenTableSchema.VORLESUNG, "Bergsteigen").set(NotenTableSchema.NOTE, "5.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "181427" ).set( NotenTableSchema.VORLESUNG, "Suchalgorithmen").set(NotenTableSchema.NOTE, "1.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "181427" ).set( NotenTableSchema.VORLESUNG, "Data-Mining").set(NotenTableSchema.NOTE, "1.3");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "181427" ).set( NotenTableSchema.VORLESUNG, "Datenschutz").set(NotenTableSchema.NOTE, "5.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "146248" ).set( NotenTableSchema.VORLESUNG, "Rechnerstrukturen").set(NotenTableSchema.NOTE, "2.3");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "146248" ).set( NotenTableSchema.VORLESUNG, "Eingebettete Systeme").set(NotenTableSchema.NOTE, "2.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "119842" ).set( NotenTableSchema.VORLESUNG, "Informationssysteme").set(NotenTableSchema.NOTE, "1.3");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "119842" ).set( NotenTableSchema.VORLESUNG, "Datenbanktheorie").set(NotenTableSchema.NOTE, "1.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "119842" ).set( NotenTableSchema.VORLESUNG, "Theoretische Informatik").set(NotenTableSchema.NOTE, "5.0");	
		db.insert(this.noten);
	
		sql = db.sql();
		sql.set( NotenTableSchema.MATRIKELNR, "181427" ).set( NotenTableSchema.VORLESUNG, "Wissensmodellierung").set(NotenTableSchema.NOTE, "1.7");	
		db.insert(this.noten);

	}
	
	@Override
	public void fillMaintenanceDBWithContents(NewMaintenanceDatabase mdb) throws DatabaseException {
		super.createDefaultAccessRights(mdb);
		super.createDefaultUsers(mdb);
	
		User user;
		try {
			user = mdb.getUserManagement().load(LYING_ID);
			// LYING_ID entspricht der USER_ID, die dem Lying Zensor zugeordnet wird.
			this.fillPrior(user);
			this.fillConfidentialityPolicy(user);
			
			// REFUSAL_ID entspricht der USER_ID, die dem Refusal Zensor zugeordnet wird.
			user = mdb.getUserManagement().load(REFUSAL_ID);
			this.fillPrior(user);
			this.fillConfidentialityPolicy(user);
			
			// COMBINED_ID entspricht der USER_ID, die dem Combined Zensor zugeordnet wird.
			user = mdb.getUserManagement().load(COMBINED_ID);
			this.fillPrior(user);
			this.fillConfidentialityPolicy(user);
			
			super.linkDictionary( mdb, this.studentenDict, StudentenTableSchema.STUDENT );
			super.linkDictionary( mdb, this.matrikelnrDict, StudentenTableSchema.MATRIKELNR );
			super.linkDictionary( mdb, this.birthdayDict, StudentenTableSchema.GEBURTSTAG );
			super.linkDictionary( mdb, this.matrikelnrDict, NotenTableSchema.MATRIKELNR );
			super.linkDictionary( mdb, this.vorlesungenDict, NotenTableSchema.VORLESUNG );
			super.linkDictionary( mdb, this.notenDict, NotenTableSchema.NOTE );
		} catch (UnknownUserException e1) {
			throw new DatabaseException("User does not exists, check default user creation.", e1);
		}
	}
	
	public void fillPrior(User user) throws DatabaseException {
		Formula formula;
		PriorUser prior = user.getPriorUser();
		try {
			formula = new Formula("EXISTS X,Y,Z (studenten(X,Y,Z) AND noten(X,\"Datenschutz\",\"5.0\"))");
			prior.add(formula);

		} catch (ParserException e) {
			throw new DatabaseException("Formular in test wrong, check your code.", e);
		}
	}
	
	public void fillConfidentialityPolicy(User user) throws DatabaseException {
		Formula formula;
		ConfidentialityPolicy policy = user.getConfidentialityPolicy();
		try {
			formula = new Formula("EXISTS X,Y (studenten(123456,\"Mark Zuckerberg\",X) AND noten(123456,Y,\"5.0\"))");
			policy.add(formula, CqeType.PolicyType.POTENTIAL_SECRETS, CqeType.PolicyPreservation.CONTINUOUS);

			formula = new Formula("EXISTS X,Y (studenten(111111,\"Bill Gates\",X) AND noten(111111,Y,\"5.0\"))");
			policy.add(formula, CqeType.PolicyType.POTENTIAL_SECRETS, CqeType.PolicyPreservation.CONTINUOUS);
		
			formula = new Formula("EXISTS X,Y (studenten(169681,\"Tim Berners Lee\",X) AND noten(169681,Y,\"5.0\"))");
			policy.add(formula, CqeType.PolicyType.POTENTIAL_SECRETS, CqeType.PolicyPreservation.CONTINUOUS);

			formula = new Formula("EXISTS X,Y (studenten(161163,\"Steve Ballmer\",X) AND noten(161163,Y,\"5.0\"))");
			policy.add(formula, CqeType.PolicyType.POTENTIAL_SECRETS, CqeType.PolicyPreservation.CONTINUOUS);

			formula = new Formula("EXISTS X,Y (studenten(167588,\"Linus Torvalds\",X) AND noten(167588,Y,\"5.0\"))");
			policy.add(formula, CqeType.PolicyType.POTENTIAL_SECRETS, CqeType.PolicyPreservation.CONTINUOUS);
			
			formula = new Formula("EXISTS X,Y (studenten(175057,\"Alan Turing\",X) AND noten(175057,Y,\"5.0\"))");
			policy.add(formula, CqeType.PolicyType.POTENTIAL_SECRETS, CqeType.PolicyPreservation.CONTINUOUS);

			formula = new Formula("EXISTS X,Y (studenten(156868,\"Stephen Cook\",X) AND noten(156868,Y,\"5.0\"))");
			policy.add(formula, CqeType.PolicyType.POTENTIAL_SECRETS, CqeType.PolicyPreservation.CONTINUOUS);
			
			formula = new Formula("EXISTS X,Y (studenten(192641,\"Jacques Herbrand\",X) AND noten(192641,Y,\"5.0\"))");
			policy.add(formula, CqeType.PolicyType.POTENTIAL_SECRETS, CqeType.PolicyPreservation.CONTINUOUS);
		
			formula = new Formula("EXISTS X,Y (studenten(181427,\"Larry Page\",X) AND noten(181427,Y,\"5.0\"))");
			policy.add(formula, CqeType.PolicyType.POTENTIAL_SECRETS, CqeType.PolicyPreservation.CONTINUOUS);

			formula = new Formula("EXISTS X,Y (studenten(146248,\"Paul Otellini\",X) AND noten(146248,Y,\"5.0\"))");
			policy.add(formula, CqeType.PolicyType.POTENTIAL_SECRETS, CqeType.PolicyPreservation.CONTINUOUS);

			formula = new Formula("EXISTS X,Y (studenten(119842,\"Lawrence Ellison\",X) AND noten(119842,Y,\"5.0\"))");
			policy.add(formula, CqeType.PolicyType.POTENTIAL_SECRETS, CqeType.PolicyPreservation.CONTINUOUS);
			
		} catch (ParserException e) {
			e.printStackTrace();
			fail("ParserException cought");
		}
	}
}
