package server.data;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import user.IdAndFormula;

public class Knowledge {
	
	protected Log log;
	protected PriorAll priorAll;
	protected PriorUser priorUser;
	protected SchemaConstraints schemaConstraints;
	
	public Knowledge(Log log, PriorAll priorAll, PriorUser priorUser, SchemaConstraints schemaConstraints) {
		this.log = log;
		this.priorAll = priorAll;
		this.priorUser = priorUser;
		this.schemaConstraints = schemaConstraints;
	}
	
	public List<IdAndFormula> getCopyAsList() {
		List<IdAndFormula> copy = new LinkedList<IdAndFormula>();
		
		// Log
		Iterator<LogEntry> iter = log.iterator();
		while ( iter.hasNext() ) {
			LogEntry entry = iter.next();
			copy.add( new IdAndFormula(entry.getId(), entry.getAnswer()) );
		}
		
		// PriorAll
		for ( IdAndFormulaEntry entry : priorAll.entries ) {
			IdAndFormula item = new IdAndFormula( entry.getId(), entry.getFormula() );
			copy.add( item );
		}
		
		// PriorUser
		for ( IdAndFormulaEntry entry : priorUser.entries ) {
			IdAndFormula item = new IdAndFormula( entry.getId(), entry.getFormula() );
			copy.add( item );
		}
		
		// SchemaConstraints
		for ( IdAndFormulaEntry entry : schemaConstraints.entries ) {
			IdAndFormula item = new IdAndFormula( entry.getId(), entry.getFormula() );
			copy.add( item );
		}
		
		return copy;
	}
}
