package server.core.notificationHandler;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;

import communication.CqeType;

import exception.DatabaseException;

import server.core.Client;
import server.data.Role;
import notification.clientToServer.GetAllRolesNotification;
import notification.serverToClient.AllRolesNotification;

public class GetAllRolesNotificationHandler extends NotificationHandler<GetAllRolesNotification> {

	public GetAllRolesNotificationHandler() {
		super(GetAllRolesNotification.class, EnumSet.of(CqeType.Right.MANAGE_USERS));
	}

	@Override
	protected void handle(Client client, GetAllRolesNotification notification) throws DatabaseException, IOException {		
		// FIXME: this is ugly as hell. change it.
		List<user.Role> roleList = new LinkedList<user.Role>();
		Collection<Role> roles = Role.loadAll(client.getMaintenanceDB().getDb());
		for ( Role role: roles ) {
			user.Role roleCopy = new user.Role(role.getId(), role.getName());
			roleCopy.addAll( role.getRights() );
			roleList.add( roleCopy );
		}
		client.send( new AllRolesNotification(roleList) );
	}
	
}
