package server.core.notificationHandler;

import java.util.EnumSet;

import communication.CqeType;
import exception.DatabaseException;
import exception.ParserException;
import exception.UnknownConfidentialityPolicyException;
import exception.UnknownIdAndFormulaException;
import exception.UnknownLogException;
import exception.UnknownUserException;
import exception.UnsupportedFormulaException;

import server.core.Client;
import server.data.ConfidentialityPolicyEntry;
import server.data.IdAndFormulaEntry;
import server.data.LogEntry;
import server.data.User;
import server.parser.Formula;
import server.parser.FormulaUtil;
import user.IdAndFormula;
import notification.clientToServer.EditUserInformationNotification;

public class EditUserInformationNotificationHandler extends NotificationHandler<EditUserInformationNotification>{

	public EditUserInformationNotificationHandler() {
		super(EditUserInformationNotification.class, EnumSet.of(CqeType.Right.MANAGE_USERS));
	}

	@Override
	protected void handle(Client client, EditUserInformationNotification notification) throws DatabaseException, UnknownUserException, ParserException, UnsupportedFormulaException, UnknownConfidentialityPolicyException, UnknownLogException, UnknownIdAndFormulaException {
		User user = client.getMaintenanceDB().getUserManagement().load(notification.getUserId());
		Formula formula = null;
		if ( notification.getFormula() != null ) {
			formula = new Formula( notification.getFormula() );
		}

		// FIXME: range restriction check here?
		if( !FormulaUtil.rangerestricted(formula) ) {
			throw new UnsupportedFormulaException("Formula " + formula.toString() + " is not safe range!");
		}

		switch ( notification.getType() ) {
		case IdAndFormula.TYPE_CONF_POL:
			ConfidentialityPolicyEntry entry = user.getConfidentialityPolicy().get( notification.getFormulaId() );
			// Only update non-null fields.
			if ( formula != null ) {
				entry.setFormula(formula);
			}
			if ( notification.getPreservation() != null ) {
				entry.setPreservation(notification.getPreservation());
			}
			if ( notification.getPolicyType() != null ) {
				entry.setType(notification.getPolicyType());
			}
			break;
		case IdAndFormula.TYPE_LOG:
			LogEntry logEntry = user.getLog().get( notification.getFormulaId() );
			logEntry.setAnswer(formula);
			//FIXME: show interactionType, interaction, interactionDate, answerType, effectiveUpdates in GUI Client and make it changeable.
			break;
		case IdAndFormula.TYPE_PRIOR:
			IdAndFormulaEntry formulaEntry = user.getPriorUser().get( notification.getFormulaId() );
			formulaEntry.setFormula(formula);
			break;
		default:
			// FIXME exception type doesn't fit very well
			throw new UnsupportedFormulaException( notification.getFormula() );
		}
	}

}
