package server.core;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

import org.apache.log4j.Logger;

import server.censor.CensorManagement;
import server.core.notificationHandler.NotificationHub;

/**
 * The main CIE server.
 * Starts listening for new clients upon thread start().
 * Each client has its own thread for sending and receiving data.
 * The actual data processing is done in the notification hub and not
 * in the client thread.
 */
public class Server extends Thread {
	
	private final static Logger logger = Logger.getLogger("edu.udo.cs.ls6.cie.server.core");
	private int port;
	private int clientNumber;
	private NotificationHub notificationHub;
	private CensorManagement censorManagement;
	
	public static void main ( String args[] ) {
		new Server(65000).start();
	}
	
	public Server( int port ) {
		super("CIE Server");
		this.notificationHub = NotificationHub.createBaseHub();
		this.censorManagement = new CensorManagement(this);
		this.port = port;
		this.clientNumber = 0;
	}
	
	public NotificationHub getNotificationHub() {
		return this.notificationHub;
	}
	
	public CensorManagement getCensorManagement() {
		return this.censorManagement;
	}
	
	@Override
	public void run() {
		ServerSocket server = null;
		
		try {
			server = new ServerSocket( this.port );
		} catch ( IOException exception ) {
			logger.fatal( "Server couldn't be started.", exception );
			return;
		}
		
		logger.info( "Server started." );

		while ( true ) {
			try {
				Socket clientSocket = server.accept();
				logger.info( "New connection from " + clientSocket.getRemoteSocketAddress() );
				
				Client client = new Client(this, clientSocket);
				Thread thread = new Thread(client, "Client #"+this.clientNumber);
				//Thread thread = new Application( clientSocket );
				
				thread.start();
				
				logger.debug( "Connection to new client #"+this.clientNumber+" established." );
				this.clientNumber++;
			} catch ( IOException exception ) {
				logger.error( "Couldn't establish a connection to the client.", exception );
			}
		}
	}
}
