package server.censor.basic;

import java.util.LinkedList;
import java.util.List;

import server.parser.Formula;
import exception.DatabaseException;
import exception.UnsupportedFormulaException;
import server.censor.QueryCensor;
import server.core.Client;
import server.core.Server;

/**
 * Dieser Zensor fuehrt keinerlei Inferenz- oder Zugriffskontrollmechanismen aus.
 * Er gibt das Datenbankergebnis ungefiltert an den Benutzer zurueck.
 * Es wird kein Log gefuehrt.
 */
public class DirectAccessCensor extends QueryCensor {

	public DirectAccessCensor(Server server) {
		super("DirectAccess", server);
	}

	@Override
	protected List<Formula> run(Client client, Formula interaction) throws DatabaseException, UnsupportedFormulaException {
		List<Formula> result = new LinkedList<Formula>();
		
		// Eval-Stern ausfuehren
		Formula evalStarQuery = Formula.createFormula(client.getApplicationDB().evalStarComplete(interaction));
		result.add( evalStarQuery );
		
		return result;
	}

}
