package server.censor.basic;

import java.util.LinkedList;
import java.util.List;

import server.data.ConfidentialityPolicyEntry;
import server.parser.Formula;
import server.parser.MumFormula;
import exception.DatabaseException;
import exception.UnsupportedFormulaException;
import server.censor.QueryCensor;
import server.core.Client;
import server.core.Server;

/**
 * Der AccessControlCensor fuehrt statt Inferernzkontrolle eine reine
 * Zugriffskontrolle durch. Ist die Anfrage oder seine Negation in der Menge der
 * potentiellen Geheimnisse, so wird die Anfrage verweigert. Ansonsten wird das
 * Datenbankergebnis zurueckgeliefert.
 * Fuehrt kein Log.
 *
 */
public class AccessControlCensor extends QueryCensor {

	public AccessControlCensor(Server server) {
		super("AccessControl", server);
	}

	@Override
	protected List<Formula> run(Client client, Formula interaction) throws DatabaseException, UnsupportedFormulaException {
		List<Formula> result = new LinkedList<Formula>();
		
		// Kopie der Anfrage erstellen und danach negieren.
		Formula negatedInteraction = (Formula)interaction.clone();
		negatedInteraction.negate();
		
		// Zugriffskontrolle
		for ( ConfidentialityPolicyEntry entry : client.getUser().getConfidentialityPolicy() ) {
			if ( entry.getFormula().equals(interaction) || entry.getFormula().equals(negatedInteraction) ) {
				result.add(  new MumFormula(interaction) );
				return result;
			}
		}
		
		// Eval-Stern ausfuehren
		Formula evalStarQuery = Formula.createFormula(client.getApplicationDB().evalStarComplete(interaction));
		result.add( evalStarQuery );
		
		return result;
	}

}
