package notification.serverToClient;

import java.util.List;
import java.util.Vector;

import user.IdAndFormula;

/**
 * Diese Notification wird als Antwort auf eine Query-Interaktion
 * an den Client gesendet.
 */
public class QueryResultNotification extends ResultNotification {
	private static final long serialVersionUID = -3816121642626593272L;

	private List<IdAndFormula> result;
	
	/**
	 * Erstellt eine neue Antwort, die eine Liste mit Formeln als Antwort, die Orignalanfrage und
	 * eine Liste von Formeln mit neuem Log-Wissen enthaelt.
	 * 
	 * @param result Die Antwort auf die Anfrage in Form einer Liste von Formeln.
	 * @param interaction Die Orignalanfrage des Benutzers.
	 * @param addToLog Die Informationen, die zum Log des Benutzers hinzugefuegt werden sollen.
	 */
	public QueryResultNotification(List<IdAndFormula> result, String interaction, List<IdAndFormula> addToLog) {
		super(interaction, addToLog);
		this.result = result;
	}
	
	/**
	 * Erstellt eine neue Antwort, die eine Liste mit Formeln als Antwort, die Orignalanfrage und
	 * eine Liste von Formeln mit neuem Log-Wissen enthaelt.
	 * 
	 * @param result Die Antwort auf die Anfrage in Form einer Liste von Formeln.
	 * @param interaction Die Orignalanfrage des Benutzers.
	 * @param addToLog Die Informationen, die zum Log des Benutzers hinzugefuegt werden sollen.
	 * @param processingTime Bearbeitungszeit in Millisekunden
	 */
	public QueryResultNotification(List<IdAndFormula> result, String interaction, Vector<IdAndFormula> addToLog, long processingTime) {
		super(interaction, addToLog, processingTime);
		this.result = result;
	}
	
	/**
	 * Liefert die Antwort des Zensors zurueck.
	 * @return Antwort des Zensors.
	 */
	public List<IdAndFormula> getResult() {
		return this.result;
	}
}
