package notification.serverToClient;

import java.util.Vector;

import notification.ListNotification;
import server.database.DatabaseConfiguration;
import server.database.DatabaseConfigurationList;
import server.util.Tuple;

/**
 * Notification fuer die Liste aller verfuegbaren Datenbanken, aus die der Benutzer beim Login auswaehlen kann.
 * Der angezeigte String ist ein eindeutiger Bezeichner fuer ein DatenbankConfiguration-Paar (Tupel).
 *
 */
public class AvailableDatabasesNotification extends ListNotification<String> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2723739167430802072L;

	public AvailableDatabasesNotification( DatabaseConfigurationList vector ) {
		super( new Vector<String >() );
		
		for( Tuple<DatabaseConfiguration,DatabaseConfiguration> tupel : vector ) {
			// Beide Elemente haben den selben Identifier.
			this.getVector().add( tupel.getFirstElement().getId() );
		}
	}
}
