package client.gui.usermanagement;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

import notification.serverToClient.ExceptionNotification;

import client.core.Client;

public class PreCQEPanel extends JPanel implements ActionListener {
	private static final long serialVersionUID = -9205037819115096558L;

	private UserOverviewPanel userOverviewPanel = null;
	private JButton calcButton = null;
	private JButton cleanupButton = null;
	
	public PreCQEPanel(UserOverviewPanel userOverviewPanel) {
		this.userOverviewPanel = userOverviewPanel;
		
		// Some border
		this.setBorder( BorderFactory.createTitledBorder("PreCQE") );
		
		this.calcButton = new JButton( "Calculate inference proof instance" );
		this.calcButton.addActionListener(this);
        this.add( this.calcButton, BorderLayout.WEST );

        this.cleanupButton = new JButton( "Cleanup inference proof instance" );
        this.cleanupButton.addActionListener(this);
        this.add( this.cleanupButton, BorderLayout.EAST );
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		try {
			if ( e.getActionCommand().equals("Calculate inference proof instance") ) {
				Client.GUI.sendPreCQEAction( userOverviewPanel.getSelectedUser() );
			} else if ( e.getActionCommand().equals("Cleanup inference proof instance") )	{
				Client.GUI.cleanupPreCQE( userOverviewPanel.getSelectedUser() );
			}
		} catch ( IOException ex ) {
			Client.GUI.showError("Failed to executre PreCQE command.", ex, ExceptionNotification.NONCRITICAL);
		}
	}
}
