package client.gui.mainwindow;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingConstants;


/**
 * GUI-Element: Tab-Leiste im Hauptfenster. Beinhaltet Tabs fuer das Log, die
 * potential secrets (PotSec), der constraints (funktionale Abhaengigkeiten)
 * und der vom Benutzer gestellten Querys und Updates.
 * @author schalge
 */
public class TabPanel extends JPanel {
	private static final long serialVersionUID = 5571088377763533466L;
	
	private JTabbedPane tabbedPane = null;
    public HelpPanel helpPanel = null;
    private LogTabPanel logTabPanel = null;
    private ConfidentialityPolicyTabPanel potsecTabPanel = null;
    private ConstraintTabPanel constraintTabPanel = null;
    private PriorAllTabPanel priorAllTabPanel = null;
    private PriorUserTabPanel priorUserTabPanel = null;
    
    /**
     * Erzeugt das beschriebene GUI-Element.
     */
    public TabPanel() {
        super();

        this.setLayout( new BoxLayout(this, BoxLayout.X_AXIS) );

        this.logTabPanel = new LogTabPanel();
        this.logTabPanel.showContent();
        this.potsecTabPanel = new ConfidentialityPolicyTabPanel();
        this.potsecTabPanel.showContent();
        this.constraintTabPanel = new ConstraintTabPanel();
        this.constraintTabPanel.showContent();
        this.priorAllTabPanel = new PriorAllTabPanel();
        this.priorAllTabPanel.showContent();
        this.priorUserTabPanel = new PriorUserTabPanel();
        this.priorUserTabPanel.showContent();

        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab( "Log", this.logTabPanel );
        this.tabbedPane.addTab( "ConfidentialityPolicy", this.potsecTabPanel );
        this.tabbedPane.addTab( "Constraints", this.constraintTabPanel );
        this.tabbedPane.addTab( "PriorAll", this.priorAllTabPanel );
        this.tabbedPane.addTab( "PriorUser", this.priorUserTabPanel );
        
        this.helpPanel = new HelpPanel();

        JSeparator sep = new JSeparator(SwingConstants.VERTICAL);
        sep.setMaximumSize( new Dimension(2,Integer.MAX_VALUE) );

        this.add(this.tabbedPane);
        this.add( sep );
        this.add(this.helpPanel);
    }
    
    public JTabbedPane getTabbedPane() {
    	return this.tabbedPane;
    }
    
    public ConfidentialityPolicyTabPanel getConfidentialityPolicyPanel() {
    	return this.potsecTabPanel;
    }
    
    public void hideConfidentialityPolicyPanel() {
    	this.tabbedPane.remove( this.potsecTabPanel );
    }
    
    public ConstraintTabPanel getConstraintPanel() {
    	return this.constraintTabPanel;
    }
    
    public PriorAllTabPanel getPriorAllPanel() {
    	return this.priorAllTabPanel;
    }
    
    public PriorUserTabPanel getPriorUserPanel() {
    	return this.priorUserTabPanel;
    }
    
    public LogTabPanel getLogPanel() {
    	return this.logTabPanel;
    }
    
    public void addClosableTab( String label, Component content ) {
    	this.tabbedPane.addTab( label, content );
    	this.tabbedPane.setSelectedComponent( content );
    	this.tabbedPane.setTabComponentAt( this.tabbedPane.indexOfComponent(content), new ButtonTabComponent(this.tabbedPane) );
    }
}
