package client.gui.mainwindow;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumSet;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import communication.CqeType;

import client.core.Client;




/**
 * GUI-Element: Zeigt das Panel im oberen Bereich des Hauptfensters an.
 * Beinhaltet das Logo, den Namen und die Rolle des angemeldeten Benutzers,
 * ggf. den Button fuer die Benutzerverwaltung (wenn der Benutzer die Rolle
 * eines Administrators hat) und einen Button zum abmelden.
 * @author schalge
 */
public class MainTopPanel extends JPanel implements ActionListener {
	private static final long serialVersionUID = -4089732401134523380L;
	
	private JButton userManagementButton = null;
	private JButton automatonManagementButton = null;
    private JButton logoutButton = null;
    private JLabel descUserLabel = null;
    private JLabel descRoleLabel = null;
    private JLabel descCensorLabel = null;
    private JLabel valueUserLabel = null;
    private JLabel valueRoleLabel = null;
    private JLabel valueCensorLabel = null;

    /**
     * Erzeugt das beschriebene GUI-Element.
     */
    public MainTopPanel(String username, EnumSet<CqeType.Right> rights, String censor) {
        super();
        
        // String zur Beschreibung aller Rechte aufbaun.
        String rightsDesc = "";
        String sep = "";
        for ( CqeType.Right right : rights ) {
        	rightsDesc += sep + right.toString();
        	sep = ", ";
        }

        // Start der GUI-Definition
        this.setLayout( new BoxLayout(this, BoxLayout.X_AXIS) );
        this.setBorder( BorderFactory.createMatteBorder(0, 0, 1, 0, Color.DARK_GRAY) );

        JPanel descriptionPanel = new JPanel();
        descriptionPanel.setLayout( new BoxLayout(descriptionPanel, BoxLayout.Y_AXIS) );
        this.descUserLabel = new JLabel("Username:");
        this.descUserLabel.setFont( new Font("Serif", Font.BOLD, 12) );
        this.descRoleLabel = new JLabel("Access Rights:");
        this.descRoleLabel.setFont( new Font("Serif", Font.BOLD, 12) );
        this.descCensorLabel = new JLabel("Censor:");
        this.descCensorLabel.setFont( new Font("Serif", Font.BOLD, 12) );
        descriptionPanel.add( this.descUserLabel );
        descriptionPanel.add( this.descRoleLabel );
        descriptionPanel.add( this.descCensorLabel );

        JPanel valuePanel = new JPanel();
        valuePanel.setLayout( new BoxLayout(valuePanel, BoxLayout.Y_AXIS) );
        this.valueUserLabel = new JLabel();
        this.valueRoleLabel = new JLabel();
        this.valueCensorLabel = new JLabel();
        valuePanel.add( this.valueUserLabel );
        valuePanel.add( this.valueRoleLabel );
        valuePanel.add( this.valueCensorLabel );
        
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout( new BoxLayout(buttonPanel, BoxLayout.Y_AXIS) );
        this.automatonManagementButton = new JButton("Automaton Management");
        this.automatonManagementButton.addActionListener( this );
        this.automatonManagementButton.setEnabled(false);
        this.userManagementButton = new JButton("User Management");
        this.userManagementButton.addActionListener( this );
        this.logoutButton = new JButton("Logout");
        this.logoutButton.addActionListener( this );
        //this.logoutButton.setSize( new Dimension(100, this.logoutButton.getPreferredSize().height) );
        //this.logoutButton.setPreferredSize( this.logoutButton.getSize() );
        //this.logoutButton.setMaximumSize( this.logoutButton.getSize() );
        this.logoutButton.setPreferredSize( this.userManagementButton.getPreferredSize() );
        this.logoutButton.setMaximumSize( this.userManagementButton.getPreferredSize() );
        this.automatonManagementButton.setPreferredSize( this.userManagementButton.getPreferredSize() );
        this.automatonManagementButton.setMaximumSize( this.userManagementButton.getPreferredSize() );
        buttonPanel.add( this.logoutButton );
        buttonPanel.add( Box.createRigidArea(new Dimension(0,5)) );
        buttonPanel.add( this.userManagementButton );
        buttonPanel.add( this.automatonManagementButton );
        
        this.add( new JLabel(Client.imgDB.logo) );
        this.add( Box.createRigidArea(new Dimension(20,0)) );
        this.add( descriptionPanel );
        this.add( Box.createRigidArea(new Dimension(10,0)) );
        this.add( valuePanel );
        this.add( Box.createGlue() );
        this.add( buttonPanel );
        
        // Buttons nur dann anzeigen, wenn Benutzer auch das Recht hat
        // die entsprechenden Funktionen auszuführen.
        if ( !rights.contains(CqeType.Right.MANAGE_AUTOMATON) ) {
        	this.automatonManagementButton.setEnabled( false );
        }
        if ( !rights.contains(CqeType.Right.MANAGE_USERS) ) {
            this.userManagementButton.setEnabled( false );
        }
        
        // Werte fuer Labels setzen.
        this.setUsername( username );
        this.setRole( rightsDesc );
        this.setCensor( censor );


        // expand a little bit to create some space between the logout and query button
        this.setPreferredSize( new Dimension(this.getPreferredSize().width, this.getPreferredSize().height + 10) );

    }

    /**
     * Setzt die Anzeige fuer den Benutzernamen auf den angegebenen Wert.
     * @param username Neuer Benutzername.
     */
    public void setUsername(String username) {
        if ( this.valueUserLabel != null ) {
            this.valueUserLabel.setText(username);
        }
    }

    /**
     * Setzt die Anzeige fuer die Benutzer-Rolle auf den angegebenen Wert.
     * @param role Neuer Wert fuer die Benutzer-Rolle.
     */
    public void setRole(String role) {
        if ( this.valueRoleLabel != null ) {
            this.valueRoleLabel.setText(role);
        }
    }
    
    /**
     * Setzt die Anzeige fuer den aktuell verwendeten Zensor des Benutzers auf den angegebenen Wert.
     * @param censor Neue Wert fuer den aktuell verwendeten Zensor des Benutzers.
     */
    public void setCensor(String censor) {
    	if ( this.valueCensorLabel != null ) {
    		this.valueCensorLabel.setText(censor);
    	}
    }

    /**
     * Behandelt das Druecken des Logout-Button. Das Hauptfenster wird
     * geschlossen und das Anmelde-Fenster wieder angezeigt.
     * @param e Durch den Button ausgeloeste Aktion.
     */
    public void actionPerformed(ActionEvent e) {
        if ( e.getSource() == this.logoutButton ) {
            Client.GUI.logout();
        } else if ( e.getSource() == this.userManagementButton ) {
            Client.GUI.showUserManagementWindow();
        } else if ( e.getSource() == this.automatonManagementButton ) {
        	Client.GUI.showAutomatonManagementWindow();
        }
    }
}
