package client.gui.mainwindow;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import client.core.Client;




/**
 *
 * @author schalge
 */
class MainLogoPanel extends JPanel implements ActionListener {
	private static final long serialVersionUID = -738156361681962038L;
	
	private JButton userManagementButton = null;
    private JButton logoutButton = null;
    private JLabel descUserLabel = null;
    private JLabel descRoleLabel = null;
    private JLabel valueUserLabel = null;
    private JLabel valueRoleLabel = null;

    public MainLogoPanel() {
        super();

        this.setLayout( new BoxLayout(this, BoxLayout.X_AXIS) );
        this.setBorder( BorderFactory.createMatteBorder(0, 0, 1, 0, Color.DARK_GRAY) );

        JPanel descriptionPanel = new JPanel();
        descriptionPanel.setLayout( new BoxLayout(descriptionPanel, BoxLayout.Y_AXIS) );
        this.descUserLabel = new JLabel("Benutzername:");
        this.descUserLabel.setFont( new Font("Serif", Font.BOLD, 12) );
        this.descRoleLabel = new JLabel("Rolle:");
        this.descRoleLabel.setFont( new Font("Serif", Font.BOLD, 12) );
        descriptionPanel.add( this.descUserLabel );
        descriptionPanel.add( this.descRoleLabel );

        JPanel valuePanel = new JPanel();
        valuePanel.setLayout( new BoxLayout(valuePanel, BoxLayout.Y_AXIS) );
        this.valueUserLabel = new JLabel();
        this.valueRoleLabel = new JLabel();
        valuePanel.add( this.valueUserLabel );
        valuePanel.add( this.valueRoleLabel );

        this.userManagementButton = new JButton("Benutzerverwaltung");
        this.userManagementButton.addActionListener( this );

        this.logoutButton = new JButton("Logout");
        this.logoutButton.addActionListener( this );
        this.logoutButton.setSize( new Dimension(100, this.logoutButton.getPreferredSize().height) );
        this.logoutButton.setPreferredSize( this.logoutButton.getSize() );
        this.logoutButton.setMaximumSize( this.logoutButton.getSize() );

        this.add( new JLabel("CQE Logo") );
        this.add( Box.createRigidArea(new Dimension(20,0)) );
        this.add( descriptionPanel );
        this.add( Box.createRigidArea(new Dimension(10,0)) );
        this.add( valuePanel );
        this.add( Box.createGlue() );
        this.add( this.userManagementButton );
        this.add( Box.createRigidArea(new Dimension(5,0)) );
        this.add( this.logoutButton );

        this.setUsername("Testbenutzer");
        this.setRole("Administrator");


        // expand a little bit to create some space between the logout and query button
        this.setPreferredSize( new Dimension(this.getPreferredSize().width, this.getPreferredSize().height + 10) );
    }

    public void setUsername(String username) {
        if ( this.valueUserLabel != null ) {
            this.valueUserLabel.setText(username);
        }
    }

    public void setRole(String role) {
        if ( this.valueRoleLabel != null ) {
            this.valueRoleLabel.setText(role);
        }
    }

    public void actionPerformed(ActionEvent e) {
    	if ( e.getSource() == this.logoutButton ) {
			Client.GUI.logout();
		} else if ( e.getSource() == this.userManagementButton ) {
			Client.GUI.showUserManagementWindow();
		}
    }
}
