package client.gui.mainwindow;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.EnumSet;

import javax.swing.JFrame;

import communication.CqeType;

/**
 * GUI-Fenster: Hauptfenster. Besteht aus einem Panel oben, einer Tab-Leiste
 * unten links, einer Hilfeleiste unten rechts und einer Statuszeile unten.
 * @author schalge
 */
public class MainFrame extends JFrame {
	private static final long serialVersionUID = -4920891920140056816L;
	
	private MainTopPanel topPanel = null;
	private MainPanel mainPanel = null;

    /**
     * Erzeugt das beschriebene GUI-Element.
     */
    public MainFrame(String username, EnumSet<CqeType.Right> rights, String censor) {
        super();

        // set window title
        this.setTitle( "jCIE" );

        // set minimum size
        this.setMinimumSize( new Dimension(1200,800) );

        // exit application on window close
        this.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );

        // add main components
        this.setLayout( new BorderLayout() );
        this.topPanel = new MainTopPanel( username, rights, censor );
        this.mainPanel = new MainPanel();
        this.add( this.topPanel, BorderLayout.NORTH );
        this.add( this.mainPanel, BorderLayout.CENTER );

        // center on screen
        this.pack();
        this.setLocationRelativeTo( this.getRootPane() );

        this.setVisible(true);
    }
    
    public MainPanel getMainPanel() {
    	return this.mainPanel;
    }
    
    public MainTopPanel getMainTopPanel() {
    	return this.topPanel;
    }

}
