package client.gui.mainwindow;

import java.awt.Font;

import javax.swing.JList;
import javax.swing.JScrollPane;

import client.gui.ListModel;

import user.IdAndFormula;

/**
 * GUI-Tab: Zeigt den Inhalt des Tabs fuer die constraints eines Benutzers an.
 */
public class ConstraintTabPanel extends LoadingTabPanel {
	private static final long serialVersionUID = 7632735161126381033L;
	
	private JList constraintList = null;
    private ListModel<IdAndFormula> constraintModel = null;

    /**
     * Erzeugt den Inhalt des Tabs.
     */
    @Override
    public void createContent() {
    	this.constraintModel = new ListModel<IdAndFormula>();
        this.constraintList = new JList( this.constraintModel );
        this.constraintList.setFont( new Font("Times New Roman", Font.PLAIN, 16) );

        JScrollPane scrollpane = null;
        scrollpane = new JScrollPane(this.constraintList);
        this.add(scrollpane);
    }
    
    public void setModel( ListModel<IdAndFormula> model ) {
    	this.constraintModel = model;
    	this.constraintList.setModel( model );
    }
}
