package client.gui.mainwindow;

import java.awt.Font;

import javax.swing.JList;
import javax.swing.JScrollPane;

import client.gui.ListModel;

import user.ConfidentialityPolicyItem;

/**
 * GUI-Tab: Zeigt den Inhalt des Tab fuer die potential secrets eines Benutzers an.
 * @author schalge
 */
public class ConfidentialityPolicyTabPanel extends LoadingTabPanel {
	private static final long serialVersionUID = -2699374187314404046L;
	
	private JList policyList = null;
    private ListModel<ConfidentialityPolicyItem> policyModel = null;
    private JScrollPane scrollpane = null;
    
    /**
     * Erzeugt den Inhalt des Tabs.
     */
    @Override
    protected void createContent() {
    	this.policyModel = new ListModel<ConfidentialityPolicyItem>();
        this.policyList = new JList( this.policyModel );
        this.policyList.setFont( new Font("Times New Roman", Font.PLAIN, 16) );
        this.scrollpane = new JScrollPane( this.policyList );
        this.add(this.scrollpane);
    }

    public void setModel( ListModel<ConfidentialityPolicyItem> model ) {
    	this.policyModel = model;
    	this.policyList.setModel( model );
    }
}
