package client.gui.login;

import java.util.List;

import javax.swing.BoxLayout;
import javax.swing.JFrame;

/**
 * GUI-Fenster: Zeigt das Login-Fenster an. Bietet die Auswahl einer Datenbank
 * und die Eingabe eines Benutzernamen und Passworts.
 * @author schalge
 */
public class LoginFrame extends JFrame {
	private static final long serialVersionUID = 9193149946350085074L;
	
	private LoginPanel loginPanel = null;

    /**
     * Erzeugt das beschriebene GUI-Element.
     */
    public LoginFrame( List<String> availableDBs ) {
        super();

        this.setTitle( "jCIE Login" );

        // exit application on window close
        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        this.setLayout( new BoxLayout(this.getContentPane(), BoxLayout.X_AXIS) );
        this.add( new LoginLogoPanel() );
        this.loginPanel = new LoginPanel( availableDBs );
        this.add( this.loginPanel );

        // center on screen
        this.pack();
        this.setLocationRelativeTo( this.getRootPane() );

        this.setVisible(true);
    }
    
    public void toggleWrongLogin() {
    	this.loginPanel.toggleWrongLogin();
    }
}
