package client.gui;

import java.util.List;
import java.util.Vector;

import javax.swing.AbstractListModel;

/**
 * GUI-Model: Fuellt eine Liste mit dem Log eines Benutzers.
 * @author schalge
 */
public class ListModel<E> extends AbstractListModel {
	private static final long serialVersionUID = -4476495717110644992L;
	
	private List<E> vector = null;
	
	/**
	 * Erzeugt ein neues LogModel mit den uebergebenen Eintraegen.
	 * @param vector Anzuzeigende Eintraege.
	 */
	public ListModel( List<E> vector ) {
		super();
		this.vector = vector;
	}
	
	/**
	 * Erzeugt eine LogModel mit einer leeren Liste.
	 */
	public ListModel() {
		super();
		this.vector = new Vector<E>();
	}
	
    /**
     * Gibt die Anzahl der Listeneintraege (der Logeintraege) zurueck.
     * @return Anzahl der Listeneintraege.
     */
    public int getSize() {
        return this.vector.size();
    }

    /**
     * Gibt den String eines bestimmten Listenelements zurueck.
     * @param index Index des Listenelements.
     * @return String-Repraesentation des Eintrags.
     */
    public Object getElementAt( int index ) {
        return this.vector.get(index);
    }
    
    public void add( E item ) {
    	this.vector.add( item );
    	this.fireIntervalAdded( this, this.vector.size(), this.vector.size() );
    }

}
