/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.tools;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.io.Encoding;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractWriter<T extends IOObject>
extends Operator {
    private InputPort inputPort = (InputPort)this.getInputPorts().createPort("input");
    private OutputPort outputPort = (OutputPort)this.getOutputPorts().createPort("through");
    private Class<T> savedClass;

    public AbstractWriter(OperatorDescription description, Class<T> savedClass) {
        super(description);
        this.savedClass = savedClass;
        this.inputPort.addPrecondition((Precondition)new SimplePrecondition(this.inputPort, new MetaData(savedClass)));
        this.getTransformer().addRule((MDTransformationRule)new PassThroughRule(this.inputPort, this.outputPort, false));
    }

    public abstract T write(T var1) throws OperatorException;

    public void doWork() throws OperatorException {
        IOObject ioobject = this.inputPort.getData(this.savedClass);
        ioobject = this.write(ioobject);
        this.outputPort.deliver(ioobject);
    }

    protected boolean supportsEncoding() {
        return false;
    }

    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.addAll(super.getParameterTypes());
        if (this.supportsEncoding()) {
            types.addAll(Encoding.getParameterTypes((ParameterHandler)this));
        }
        return types;
    }
}

