/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.tools;

import com.rapidminer.gui.properties.PropertyPanel;
import com.rapidminer.operator.tools.OperatorParameterValueCellEditor;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.tools.XMLException;
import org.w3c.dom.Element;

public class ParameterTypeParameter
extends ParameterTypeSingle {
    private static final long serialVersionUID = -5863628921324775010L;
    private static final String ESCAPE_CHAR = "\\";
    private static final String ESCAPE_CHAR_REGEX = "\\\\";
    private static final String SEPERATOR_CHAR_REGEX = "\\.";
    private static final String SEPERATOR_CHAR = ".";

    public ParameterTypeParameter(Element element) throws XMLException {
        super(element);
        this.setOptional(false);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeParameter.class, OperatorParameterValueCellEditor.class);
    }

    public ParameterTypeParameter(String key, String description) {
        super(key, description);
        this.setOptional(false);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeParameter.class, OperatorParameterValueCellEditor.class);
    }

    public Object getDefaultValue() {
        return null;
    }

    public void setDefaultValue(Object defaultValue) {
    }

    public String getRange() {
        return "values";
    }

    public boolean isNumerical() {
        return false;
    }

    public String notifyOperatorRenaming(String oldOperatorName, String newOperatorName, String parameterValue) {
        OperatorParameterSelection selection = ParameterTypeParameter.transformString2OperatorValueSelection(parameterValue);
        if (selection != null) {
            if (selection.getOperator().equals(oldOperatorName)) {
                selection.operatorName = newOperatorName;
            }
            return ParameterTypeParameter.transformOperatorValueSelection2String(selection);
        }
        return parameterValue;
    }

    public static OperatorParameterSelection transformString2OperatorValueSelection(String parameterValue) {
        String[] unescaped = parameterValue.split("(?<=[^\\\\])\\.", -1);
        for (int i = 0; i < unescaped.length; ++i) {
            unescaped[i] = ParameterTypeParameter.unescape(unescaped[i]);
        }
        OperatorParameterSelection selection = new OperatorParameterSelection();
        if (unescaped.length == 3) {
            selection.operatorName = unescaped[0];
            selection.valueParameterName = unescaped[2];
            selection.isValue = unescaped[1].equals("value");
            return selection;
        }
        return null;
    }

    private static String unescape(String escapedString) {
        escapedString = escapedString.replace(SEPERATOR_CHAR_REGEX, SEPERATOR_CHAR);
        escapedString = escapedString.replace(ESCAPE_CHAR_REGEX, ESCAPE_CHAR);
        return escapedString;
    }

    public static String transformOperatorValueSelection2String(OperatorParameterSelection selection) {
        String operator = selection.operatorName != null ? selection.getOperator().replace(ESCAPE_CHAR, ESCAPE_CHAR_REGEX) : "";
        operator = operator.replace(SEPERATOR_CHAR, SEPERATOR_CHAR_REGEX);
        String value = selection.valueParameterName != null ? selection.valueParameterName.replace(ESCAPE_CHAR, ESCAPE_CHAR_REGEX) : "";
        value = value.replace(SEPERATOR_CHAR, SEPERATOR_CHAR_REGEX);
        String stringRepresentation = operator + SEPERATOR_CHAR + (selection.isValue ? "value" : "parameter") + SEPERATOR_CHAR + value;
        return stringRepresentation;
    }

    protected void writeDefinitionToXML(Element typeElement) {
    }

    public static class OperatorParameterSelection {
        private String operatorName;
        private String valueParameterName;
        private boolean isValue;

        public OperatorParameterSelection() {
        }

        public OperatorParameterSelection(String operatorName, boolean isValue, String valueOrParameterName) {
            this.operatorName = operatorName;
            this.valueParameterName = valueOrParameterName;
            this.isValue = isValue;
        }

        public String getOperator() {
            return this.operatorName;
        }

        public String getParameterName() {
            if (!this.isValue) {
                return this.valueParameterName;
            }
            return null;
        }

        public String getValueName() {
            if (this.isValue) {
                return this.valueParameterName;
            }
            return null;
        }

        public boolean isValue() {
            return this.isValue;
        }
    }
}

