package de.dwds.ddc.client;

/** utility class for DDC server/client protocol socket communications */
public class DDCUtils {

	//-----------------------------------------------------------------
	// size <-> bytes conversions
	/** convert ddc-protocol size message-bytes to an integer size.
	 * @param bytes 32-bit integer bytes in LSB order
	 * @return size
	 */
	public static int bytesToSize(byte[] bytes) {
		int sz = 0;
		if (bytes.length > 0) { sz |= (((int)bytes[0]&0xff)); }
		if (bytes.length > 1) { sz |= (((int)bytes[1]&0xff)<<8); }
		if (bytes.length > 2) { sz |= (((int)bytes[2]&0xff)<<16); }
		if (bytes.length > 3) { sz |= (((int)bytes[3]&0xff)<<24); }
		return sz;
	}

	/** convert integer size to ddc-protocol size message bytes
	 * @param sz integer size
	 * @return 4-byte array of in LSB order
	 */
	public static byte[] sizeToBytes(int sz) {
		byte[] buf= {0,0,0,0};
		buf[0] = (byte) ( sz      & 0xff);
		buf[1] = (byte) ((sz>> 8) & 0xff);
		buf[2] = (byte) ((sz>>16) & 0xff);
		buf[3] = (byte) ((sz>>24) & 0xff);
		return buf;
	}
	
	//-----------------------------------------------------------------
	// filename utilities
	
	/** strips directory name from a filename */
	public static String fileBasename(String filename)
	{
		String[] parts = filename.split("[\\/:]");
		return parts[parts.length-1];
	}

}
