/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mrmr;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.mrmr.AbstractMRMRCriterion;
import com.rapidminer.operator.mrmr.MRMRCache;
import com.rapidminer.operator.mrmr.MRMRFunctions;
import java.util.Iterator;

public class RelevanceCriterion
extends AbstractMRMRCriterion {
    private static final long serialVersionUID = -5023462384084564554L;

    public RelevanceCriterion(MRMRCache cache) {
        super(cache);
        this.direction = 1;
    }

    public RelevanceCriterion(RelevanceCriterion rc, MRMRCache cache) {
        super(rc, cache);
        this.information_value = rc.information_value;
        this.counter = rc.counter;
        this.direction = rc.direction;
    }

    @Override
    public String getName() {
        return "relevance_of_attributes";
    }

    @Override
    public String getDescription() {
        return "Measures average relevance of all attributes in the example set concerning the label.";
    }

    public void startCounting(ExampleSet eSet, boolean useExampleWeights) throws OperatorException {
        this.startCounting(eSet, new AttributeWeights(eSet));
    }

    public void startCounting(ExampleSet eSet, AttributeWeights aw) throws OperatorException {
        Attributes attributes = eSet.getAttributes();
        Attribute label = attributes.getLabel();
        this.information_value = 0.0;
        this.counter = 0.0;
        Iterator it = eSet.getAttributes().regularAttributes();
        String key = "";
        String name = "";
        double value = 0.0;
        while (it.hasNext()) {
            Attribute x = ((AttributeRole)it.next()).getAttribute();
            name = x.getName();
            if (aw.getWeight(name) != 1.0) continue;
            this.counter += 1.0;
            key = "Rel_" + name;
            if (this.cache != null && this.cache.containsKey(key)) {
                this.information_value += this.cache.get(key).doubleValue();
                continue;
            }
            value = MRMRFunctions.GetSimilarity(eSet, x, label);
            if (this.cache != null) {
                this.cache.put(key, value);
            }
            this.information_value += value;
        }
        this.information_value = this.counter != 0.0 ? (this.information_value /= this.counter) : 0.0;
    }
}

