/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mrmr;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.mrmr.AbstractMRMRCriterion;
import com.rapidminer.operator.mrmr.MRMRCache;
import com.rapidminer.operator.mrmr.MRMRFunctions;
import com.rapidminer.tools.math.Averagable;
import java.util.Iterator;

public class RedundancyCriterion
extends AbstractMRMRCriterion {
    private static final long serialVersionUID = -5723492349523843154L;

    public RedundancyCriterion(MRMRCache cache) {
        super(cache);
        this.direction = 0;
    }

    public RedundancyCriterion(RedundancyCriterion rc, MRMRCache cache) {
        super(rc, cache);
        this.information_value = rc.information_value;
        this.counter = rc.counter;
        this.direction = rc.direction;
    }

    @Override
    public String getName() {
        return "redundancy_of_attributes";
    }

    @Override
    public String getDescription() {
        return "Measures redundancy of all attributes in the example set.";
    }

    public void startCounting(ExampleSet eSet, boolean useExampleWeights) throws OperatorException {
        this.startCounting(eSet, new AttributeWeights(eSet));
    }

    public void startCounting(ExampleSet eSet, AttributeWeights weights) throws OperatorException {
        Attributes attributes = eSet.getAttributes();
        Iterator itx = attributes.regularAttributes();
        this.information_value = 0.0;
        this.counter = 0.0;
        String key = "";
        String x_name = "";
        String y_name = "";
        double value = 0.0;
        while (itx.hasNext()) {
            AttributeRole rx = (AttributeRole)itx.next();
            Attribute x = rx.getAttribute();
            x_name = x.getName();
            if (weights.getWeight(x_name) != 1.0) continue;
            Iterator ity = attributes.regularAttributes();
            while (ity.hasNext()) {
                Attribute y;
                AttributeRole ry = (AttributeRole)ity.next();
                if (rx == ry || weights.getWeight(y_name = (y = ry.getAttribute()).getName()) != 1.0) continue;
                this.counter += 1.0;
                key = x_name + "_Red_" + y.getName();
                if (this.cache != null && this.cache.containsKey(key)) {
                    this.information_value += this.cache.get(key).doubleValue();
                    continue;
                }
                value = MRMRFunctions.GetSimilarity(eSet, x, y);
                if (this.cache != null) {
                    this.cache.put(key, value);
                }
                this.information_value += value;
            }
        }
        this.information_value = this.counter > 0.0 ? (this.information_value /= this.counter) : 1.0;
    }

    @Override
    public void buildSingleAverage(Averagable averagable) {
        RedundancyCriterion other = (RedundancyCriterion)averagable;
        this.information_value += other.information_value;
    }
}

