/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mrmr;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.weighting.AbstractWeighting;
import com.rapidminer.operator.mrmr.MRMRFunctions;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.Iterator;
import java.util.List;

public class MaximumRelevanceWeighting
extends AbstractWeighting {
    public static final String PARAMETER_KEEP_EXAMPLESET = "keep_exampleset";
    public static final String PARAMETER_ENSEMBLE = "use_ensemble";
    public static final String PARAMETER_ENSEMBLE_SIZE = "ensemble_size";

    public MaximumRelevanceWeighting(OperatorDescription description) {
        super(description);
    }

    protected AttributeWeights calculateWeights(ExampleSet exampleSet) throws OperatorException {
        if (exampleSet.getAttributes().getLabel() == null) {
            throw new UserError((Operator)this, 105);
        }
        AttributeWeights resWeights = new AttributeWeights(exampleSet);
        Attribute label = exampleSet.getAttributes().getLabel();
        Iterator it = exampleSet.getAttributes().regularAttributes();
        if (this.getParameterAsBoolean(PARAMETER_ENSEMBLE)) {
            int ensembleSize = this.getParameterAsInt(PARAMETER_ENSEMBLE_SIZE);
            while (it.hasNext()) {
                Attribute att = ((AttributeRole)it.next()).getAttribute();
                resWeights.setWeight(att.getName(), MRMRFunctions.GetSimilarity(exampleSet, att, label, ensembleSize));
            }
        } else {
            while (it.hasNext()) {
                Attribute att = ((AttributeRole)it.next()).getAttribute();
                resWeights.setWeight(att.getName(), MRMRFunctions.GetSimilarity(exampleSet, att, label));
            }
        }
        return resWeights;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_EXAMPLESET, "Keep the example set.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_ENSEMBLE, "Use ensembles of similartiy measures", false));
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_ENSEMBLE_SIZE, "Size of the ensembles", 2, Integer.MAX_VALUE, 10);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENSEMBLE, false, true));
        types.add(type);
        return types;
    }

    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case BINOMINAL_LABEL: 
            case POLYNOMINAL_LABEL: 
            case NUMERICAL_LABEL: 
            case BINOMINAL_ATTRIBUTES: 
            case POLYNOMINAL_ATTRIBUTES: 
            case NUMERICAL_ATTRIBUTES: {
                return true;
            }
        }
        return false;
    }
}

