/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.List;

public class Weights2Ranking
extends Operator {
    private final String PARAMETER_ABSOLUTE = "use_absolute_weights";
    private final InputPort weightsInput = this.getInputPorts().createPort("weights", AttributeWeights.class);
    private final OutputPort weightsOutput = (OutputPort)this.getOutputPorts().createPort("weights");

    public Weights2Ranking(OperatorDescription description) {
        super(description);
    }

    public void doWork() throws OperatorException {
        AttributeWeights weights = (AttributeWeights)this.weightsInput.getData();
        String[] attributeNames = new String[weights.getAttributeNames().size()];
        attributeNames = weights.getAttributeNames().toArray(attributeNames);
        boolean absolute = this.getParameterAsBoolean("use_absolute_weights");
        weights.sortByWeight(attributeNames, -1, absolute ? 1 : 0);
        for (int i = 0; i < attributeNames.length; ++i) {
            weights.setWeight(attributeNames[i], (double)(i + 1));
        }
        this.weightsOutput.deliver((IOObject)weights);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("use_absolute_weights", "Use the absolute attribute weights. Useful for e.g. SVM weights which can produce large negative weights for attribute with a huge influence which are anti-correlated.", false));
        return types;
    }
}

