/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.filter.MissingValueReplenishment;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.List;

public class ValueReplenishmentWithOffset
extends MissingValueReplenishment {
    protected double offset = 0.0;
    private static final String PARAMETER_OFFSET = "offset";

    public ValueReplenishmentWithOffset(OperatorDescription description) {
        super(description);
    }

    public double getReplenishmentValue(int functionIndex, ExampleSet exampleSet, Attribute attribute) throws UserError {
        try {
            this.offset = this.getParameterAsDouble(PARAMETER_OFFSET);
        }
        catch (UndefinedParameterError e1) {
            this.offset = 0.0;
        }
        if (attribute.isNumerical()) {
            return super.getReplenishmentValue(functionIndex, exampleSet, attribute) + this.offset;
        }
        return super.getReplenishmentValue(functionIndex, exampleSet, attribute);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeDouble(PARAMETER_OFFSET, "This offset is added to the replenishment value for numerical attributes.", Double.MIN_VALUE, Double.MAX_VALUE, 0.0));
        return types;
    }
}

