/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import java.util.Iterator;
import org.jfree.util.Log;

public class Util {
    public static double Pearson(double[][] ww, int i, int j, int len) {
        double E_X = 0.0;
        double E_XX = 0.0;
        double E_Y = 0.0;
        double E_YY = 0.0;
        double E_XY = 0.0;
        for (int l = 0; l < len; ++l) {
            double xi = ww[i][l];
            double yi = ww[j][l];
            E_X += xi;
            E_XX += xi * xi;
            E_Y += yi;
            E_YY += yi * yi;
            E_XY += xi * yi;
        }
        double zaehler = E_XY - E_X * E_Y / (double)len;
        double nenner = Math.sqrt(Math.abs((E_XX - E_X * E_X / (double)len) * (E_YY - E_Y * E_Y / (double)len)));
        if (nenner == 0.0) {
            if (zaehler == 0.0) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        return zaehler / nenner;
    }

    public static double Jaccard(double[][] ww, int i, int j, int len) {
        double zaehler = 0.0;
        double nenner = 0.0;
        for (int l = 0; l < len; ++l) {
            if (ww[i][l] > 0.0 && ww[j][l] > 0.0) {
                zaehler += 1.0;
            }
            if (!(ww[i][l] > 0.0) && !(ww[j][l] > 0.0)) continue;
            nenner += 1.0;
        }
        if (nenner != 0.0) {
            return zaehler / nenner;
        }
        return 0.0;
    }

    public static double averagePearsonCorrelation(String[] attributeNames, AttributeWeights[] weights, int repetitions) {
        int numberWeights = attributeNames.length;
        double[][] ww = new double[repetitions][];
        for (int i = 0; i < repetitions; ++i) {
            ww[i] = new double[numberWeights];
            for (int j = 0; j < numberWeights; ++j) {
                ww[i][j] = weights[i].getWeight(attributeNames[j]);
            }
        }
        double Stot = 0.0;
        for (int i = 0; i < repetitions; ++i) {
            for (int j = i + 1; j < repetitions; ++j) {
                Stot += Util.Pearson(ww, i, j, numberWeights);
            }
        }
        Stot *= 2.0;
        return Stot /= (double)(repetitions * (repetitions - 1));
    }

    public static double[] averageRobustness(String[] attributeNames, AttributeWeights[] weights) {
        int i;
        int len = weights.length;
        double[] result = new double[]{0.0, 0.0};
        for (i = 0; i < len; ++i) {
            for (int j = i + 1; j < len; ++j) {
                double[] temp = Util.pairwiseRobustness(attributeNames, weights[i], weights[j]);
                result[0] = result[0] + temp[0];
                result[1] = result[1] + temp[1];
            }
        }
        i = 0;
        while (i < result.length) {
            int n = i;
            result[n] = result[n] * 2.0;
            int n2 = i++;
            result[n2] = result[n2] / (double)(len * (len - 1));
        }
        return result;
    }

    public static double[] pairwiseRobustness(String[] attributeNames, AttributeWeights w1, AttributeWeights w2) {
        double[] result = new double[]{0.0, 0.0};
        double intersect = 0.0;
        double union = 0.0;
        double n = attributeNames.length;
        double k1 = 0.0;
        double k2 = 0.0;
        for (String name : attributeNames) {
            double x = w1.getWeight(name);
            double y = w2.getWeight(name);
            if (x > 0.0) {
                k1 += 1.0;
            }
            if (y > 0.0) {
                k2 += 1.0;
            }
            union += Math.max(x, y);
            intersect += Math.min(x, y);
        }
        if (k1 != k2) {
            Log.error((Object)("Subsets of different sizes were selected (" + k1 + " vs. " + k2 + ")."));
        }
        double k = Math.max(k1, k2);
        result[0] = union == 0.0 ? 0.0 : intersect / union;
        result[1] = k == 0.0 || n - k == 0.0 || union == 0.0 ? 0.0 : (intersect * n - k * k) / (k * (n - k));
        return result;
    }

    public static double averageJaccard(String[] attributeNames, AttributeWeights[] weights, int repetitions) {
        int numberWeights = attributeNames.length;
        double[][] ww = new double[repetitions][];
        for (int i = 0; i < repetitions; ++i) {
            ww[i] = new double[numberWeights];
            for (int j = 0; j < numberWeights; ++j) {
                ww[i][j] = weights[i].getWeight(attributeNames[j]);
            }
        }
        double Stot = 0.0;
        for (int i = 0; i < repetitions; ++i) {
            for (int j = i + 1; j < repetitions; ++j) {
                Stot += Util.Jaccard(ww, i, j, numberWeights);
            }
        }
        Stot *= 2.0;
        return Stot /= (double)(repetitions * (repetitions - 1));
    }

    public static String[] getAttributeNames(ExampleSet exampleset) {
        String[] attributeNames = new String[exampleset.getAttributes().size()];
        Iterator it = exampleset.getAttributes().iterator();
        int i = 0;
        while (it.hasNext()) {
            attributeNames[i++] = ((Attribute)it.next()).getName();
        }
        return attributeNames;
    }

    public static int maxIndex(double[] array) {
        double max = Double.NEGATIVE_INFINITY;
        int result = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] > max)) continue;
            max = array[i];
            result = i;
        }
        return result;
    }

    public static int minIndex(double[] array) {
        double min = Double.POSITIVE_INFINITY;
        int result = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] < min)) continue;
            min = array[i];
            result = i;
        }
        return result;
    }

    public static void SetWeightstoZero(AttributeWeights w) {
        for (String name : w.getAttributeNames()) {
            w.setWeight(name, 0.0);
        }
    }

    public static AttributeWeights CreateZeroWeights(ExampleSet e) {
        AttributeWeights result = new AttributeWeights(e);
        Util.SetWeightstoZero(result);
        return result;
    }
}

