/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.features.weighting.SVMWeighting;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.OperatorService;
import java.util.List;

public class RecursiveFeatureEliminationSVM
extends Operator {
    public static final String PARAMETER_K = "k";
    public static final String PARAMETER_C = "C";
    public static final String PARAMETER_RATIO = "ratio";
    public static final String PARAMETER_REMOVE_FEATURES = "remove_features";
    private int iteration = 0;
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort weightsOutput = (OutputPort)this.getOutputPorts().createPort("attribute weights");

    public RecursiveFeatureEliminationSVM(OperatorDescription description) {
        super(description);
        this.addValue((Value)new ValueDouble("iteration", "The number of the current iteration."){

            public double getDoubleValue() {
                return RecursiveFeatureEliminationSVM.this.iteration;
            }
        });
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
    }

    public void doWork() throws OperatorException {
        AttributeWeights weights;
        int k = this.getParameterAsInt(PARAMETER_K);
        double ratio = this.getParameterAsDouble(PARAMETER_RATIO);
        ExampleSet inputSet = (ExampleSet)this.exampleSetInput.getData();
        if (!this.getParameterAsBoolean(PARAMETER_REMOVE_FEATURES)) {
            inputSet = (ExampleSet)inputSet.copy();
        }
        SVMWeighting svmw = null;
        try {
            svmw = (SVMWeighting)OperatorService.createOperator(SVMWeighting.class);
        }
        catch (OperatorCreationException e) {
            throw new UserError((Operator)this, 904, new Object[]{"inner SVM operator", e.getMessage()});
        }
        svmw.setParameter(PARAMETER_C, this.getParameter(PARAMETER_C));
        this.iteration = 0;
        int size = inputSet.getAttributes().size();
        while (size > k) {
            ++this.iteration;
            if ((size = (int)((double)size * ratio)) < k) {
                size = k;
            }
            weights = svmw.doWork(inputSet);
            weights.normalize();
            inputSet = this.selectTopK(inputSet, weights, size);
        }
        weights = new AttributeWeights(inputSet);
        this.exampleSetOutput.deliver((IOObject)inputSet);
        this.weightsOutput.deliver((IOObject)weights);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_K, "The number of features to select.", 1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeDouble(PARAMETER_C, "Parameter C for SVM. 0 lets jMySVM estimate a good value (Average 1/K(x,x)).", 0.0, Double.MAX_VALUE, 0.0));
        types.add(new ParameterTypeDouble(PARAMETER_RATIO, "The percentage of features to keep in each iteration.", 0.0, 1.0, 0.5));
        types.add(new ParameterTypeBoolean(PARAMETER_REMOVE_FEATURES, "Remove deselected features. Faster, but handle with care. Removes features from example set. Do not use inside cross validation and other repeated chains.", false));
        return types;
    }

    protected ExampleSet selectTopK(ExampleSet exampleset, AttributeWeights weights, int k) {
        Attributes attributes = exampleset.getAttributes();
        String[] attributeNames = new String[attributes.size()];
        int index = 0;
        for (Attribute attribute : attributes) {
            attributeNames[index] = attribute.getName();
            if (Double.isNaN(weights.getWeight(attributeNames[index]))) {
                weights.setWeight(attributeNames[index], Double.NEGATIVE_INFINITY);
            }
            ++index;
        }
        weights.sortByWeight(attributeNames, -1, 0);
        int p = attributes.size();
        Attribute att = null;
        for (int i = k; i < p; ++i) {
            att = attributes.get(attributeNames[i]);
            attributes.remove(att);
        }
        return exampleset;
    }
}

