/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.fcbf;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.fcbf.FCBFModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import java.util.List;

public class FCBFOperator
extends Operator {
    protected final InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    protected final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    protected final OutputPort exampleSetBestOutput = (OutputPort)this.getOutputPorts().createPort("example set best");
    protected final OutputPort weightsOutput = (OutputPort)this.getOutputPorts().createPort("weights");
    public static final String PARAMETER_THRESHOLD = "threshold";

    public FCBFOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule(this.exampleSetBestOutput, ExampleSet.class));
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule(this.weightsOutput, AttributeWeights.class));
    }

    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        double threshold = this.getParameterAsDouble(PARAMETER_THRESHOLD);
        FCBFModel fcbfModel = new FCBFModel(exampleSet, threshold);
        this.exampleSetOutput.deliver((IOObject)exampleSet);
        this.exampleSetBestOutput.deliver((IOObject)fcbfModel.computeExampleSetBest());
        this.weightsOutput.deliver((IOObject)fcbfModel.getWeights());
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeDouble(PARAMETER_THRESHOLD, "Threshold for relevant features in FCBF. Range 0.0 to 1.0.", 0.0, 1.0, 0.0));
        return types;
    }
}

