/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.fcbf;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.fcbf.FCBFAttribute;
import com.rapidminer.operator.fcbf.FCBFAttributeLabel;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class FCBFModel {
    protected double threshold;
    protected ExampleSet exampleSet;
    protected ExampleSet exampleSetBest;
    protected AttributeWeights weights;
    protected FCBFAttributeLabel fcbfAttributeLabel;
    protected List<FCBFAttribute> fcbfAttributeVector;

    public FCBFModel(ExampleSet exampleSet, double threshold) {
        this.exampleSet = exampleSet;
        this.threshold = threshold;
        Attribute labelAttribute = exampleSet.getAttributes().getLabel();
        Vector<Integer> discretizedValues = new Vector<Integer>();
        for (Example example : exampleSet) {
            discretizedValues.add((int)example.getValue(labelAttribute));
        }
        this.fcbfAttributeLabel = new FCBFAttributeLabel(labelAttribute, discretizedValues);
        this.fcbfAttributeVector = new Vector<FCBFAttribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            discretizedValues = new Vector();
            for (Example example : exampleSet) {
                discretizedValues.add((int)example.getValue(attribute));
            }
            FCBFAttribute fcbfAttribute = new FCBFAttribute(attribute, discretizedValues, this.fcbfAttributeLabel);
            if (!(fcbfAttribute.getClassSU() > threshold)) continue;
            this.fcbfAttributeVector.add(fcbfAttribute);
        }
        Collections.sort(this.fcbfAttributeVector);
        int fcbfAttributeVectorSize = this.fcbfAttributeVector.size();
        Vector<Boolean> predominant = new Vector<Boolean>(fcbfAttributeVectorSize);
        predominant.setSize(fcbfAttributeVectorSize);
        for (int i = 0; i < fcbfAttributeVectorSize; ++i) {
            predominant.set(i, true);
        }
        for (int j = 0; j < fcbfAttributeVectorSize; ++j) {
            if (((Boolean)predominant.get(j)).equals(false)) continue;
            for (int i = j + 1; i < fcbfAttributeVectorSize; ++i) {
                double mutualSU;
                if (((Boolean)predominant.get(i)).equals(false) || !((mutualSU = this.fcbfAttributeVector.get(j).calculateMutualSU(this.fcbfAttributeVector.get(i))) >= this.fcbfAttributeVector.get(i).getClassSU())) continue;
                predominant.set(i, false);
            }
        }
        this.weights = new AttributeWeights(exampleSet);
        for (Attribute attribute : exampleSet.getAttributes()) {
            this.weights.setWeight(attribute.getName(), 0.0);
        }
        for (int i = 0; i < fcbfAttributeVectorSize; ++i) {
            if (!((Boolean)predominant.get(i)).equals(true)) continue;
            this.weights.setWeight(this.fcbfAttributeVector.get((int)i).attribute.getName(), 1.0);
        }
    }

    public AttributeWeights getWeights() {
        return this.weights;
    }

    public ExampleSet computeExampleSetBest() {
        this.exampleSetBest = (ExampleSet)this.exampleSet.copy();
        Vector<Attribute> attributesToRemove = new Vector<Attribute>();
        for (Attribute attribute : this.exampleSetBest.getAttributes()) {
            if (!(this.weights.getWeight(attribute.getName()) < 0.5)) continue;
            attributesToRemove.add(attribute);
        }
        int attributesToRemoveSize = attributesToRemove.size();
        for (int i = 0; i < attributesToRemoveSize; ++i) {
            this.exampleSetBest.getAttributes().remove((Attribute)attributesToRemove.get(i));
        }
        return this.exampleSetBest;
    }
}

