/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.bahsic;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.bahsic.BAHSICOperator;
import com.rapidminer.operator.bahsic.HSICEstimator;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.Kernel;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelAnova;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelEpanechnikov;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelGaussianCombination;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelMultiquadric;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelNeural;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelPolynomial;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelRadial;
import com.rapidminer.tools.container.Tupel;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;

public class BAHSICFeatureSelector {
    ExampleSet exampleSet;
    ExampleSet exampleSetBest;
    RealMatrix x;
    RealMatrix y;
    Kernel kernelx;
    Kernel kernely;
    int kernelxType;
    int kernelyType;
    int xrows;
    int xcols;
    int yrows;
    int ycols;
    int desiredFeatures;
    double fractionEliminated;
    boolean optimize;
    Vector<Attribute> allAttributes;
    Vector<Integer> eliminatedFeatures;
    Vector<Vector<Double>> parameterValuesOptimization;
    HSICEstimator hsicEstimator;
    RealMatrix hlhMatrix;

    public BAHSICFeatureSelector(ExampleSet exampleSet, Kernel kernelx, int kernelxType, Kernel kernely, int kernelyType, int desiredFeatures, double fractionEliminated) {
        int j;
        this.exampleSet = exampleSet;
        this.kernelx = kernelx;
        this.kernelxType = kernelxType;
        this.kernely = kernely;
        this.kernelyType = kernelyType;
        this.desiredFeatures = desiredFeatures;
        this.fractionEliminated = fractionEliminated;
        this.xrows = exampleSet.size();
        this.xcols = exampleSet.getAttributes().size();
        this.x = MatrixUtils.createRealMatrix(this.xrows, this.xcols);
        int i = 0;
        for (Example example : exampleSet) {
            j = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                this.x.setEntry(i, j, example.getNumericalValue(attribute));
                ++j;
            }
            ++i;
        }
        Vector<Attribute> labelVector = this.getLabels(exampleSet);
        this.yrows = this.xrows;
        this.ycols = labelVector.size();
        this.y = MatrixUtils.createRealMatrix(this.yrows, this.ycols);
        i = 0;
        for (Example example : exampleSet) {
            for (j = 0; j < this.ycols; ++j) {
                this.y.setEntry(i, j, example.getNumericalValue(labelVector.get(j)));
            }
            ++i;
        }
        this.allAttributes = new Vector();
        for (Attribute attribute : exampleSet.getAttributes()) {
            this.allAttributes.add(attribute);
        }
        desiredFeatures = Math.min(desiredFeatures, this.xcols);
        this.optimize = false;
        this.parameterValuesOptimization = null;
    }

    public void biasedBAHSIC() throws OperatorException {
        int j;
        Vector<Boolean> currentFeatures = new Vector<Boolean>();
        int remainingFeatureCount = this.xcols;
        for (j = 0; j < this.xcols; ++j) {
            currentFeatures.add(true);
        }
        this.hsicEstimator = new HSICEstimator(this.kernelx, this.kernely, this.y, true);
        this.hlhMatrix = this.hsicEstimator.computeHLHFast();
        this.eliminatedFeatures = new Vector();
        Vector<Tupel> hsicValues = new Vector<Tupel>();
        while (remainingFeatureCount > 0) {
            if (this.optimize) {
                this.optimizeParameters(currentFeatures, true);
            }
            hsicValues.clear();
            for (j = 0; j < this.xcols; ++j) {
                if (!currentFeatures.get(j).booleanValue()) continue;
                currentFeatures.set(j, false);
                RealMatrix kMatrix = this.hsicEstimator.computeKernelMatrix(this.x, this.kernelx, currentFeatures);
                double hsicValue = this.hsicEstimator.biasedHSIC(kMatrix, this.hlhMatrix);
                hsicValues.add(new Tupel((Comparable)Double.valueOf(hsicValue), (Object)j));
                currentFeatures.set(j, true);
            }
            Collections.sort(hsicValues);
            int eliminatingFeatureCount = (int)Math.max(Math.floor(this.fractionEliminated * (double)remainingFeatureCount), 1.0);
            for (j = remainingFeatureCount - 1; j >= remainingFeatureCount - eliminatingFeatureCount; --j) {
                int index = (Integer)((Tupel)hsicValues.get(j)).getSecond();
                currentFeatures.set(index, false);
                this.eliminatedFeatures.add(index);
            }
            remainingFeatureCount -= eliminatingFeatureCount;
        }
    }

    public void unbiasedBAHSIC() throws OperatorException {
        int j;
        Vector<Boolean> currentFeatures = new Vector<Boolean>();
        int remainingFeatureCount = this.xcols;
        for (j = 0; j < this.xcols; ++j) {
            currentFeatures.add(true);
        }
        this.hsicEstimator = new HSICEstimator(this.kernelx, this.kernely, this.y, false);
        this.eliminatedFeatures = new Vector();
        Vector<Tupel> hsicValues = new Vector<Tupel>();
        while (remainingFeatureCount > 0) {
            if (this.optimize) {
                this.optimizeParameters(currentFeatures, false);
            }
            hsicValues.clear();
            for (j = 0; j < this.xcols; ++j) {
                if (!currentFeatures.get(j).booleanValue()) continue;
                currentFeatures.set(j, false);
                RealMatrix kMatrix = this.hsicEstimator.computeKernelMatrix(this.x, this.kernelx, currentFeatures);
                double hsicValue = this.hsicEstimator.unbiasedHSIC(kMatrix);
                hsicValues.add(new Tupel((Comparable)Double.valueOf(hsicValue), (Object)j));
                currentFeatures.set(j, true);
            }
            Collections.sort(hsicValues);
            int eliminatingFeatureCount = (int)Math.max(Math.floor(this.fractionEliminated * (double)remainingFeatureCount), 1.0);
            for (j = remainingFeatureCount - 1; j >= remainingFeatureCount - eliminatingFeatureCount; --j) {
                int index = (Integer)((Tupel)hsicValues.get(j)).getSecond();
                currentFeatures.set(index, false);
                this.eliminatedFeatures.add(index);
            }
            remainingFeatureCount -= eliminatingFeatureCount;
        }
    }

    public void optimizeParameters(Vector<Boolean> currentFeatures, boolean biased) throws OperatorException {
        boolean ok;
        int i;
        int parameterCount = BAHSICOperator.PARAMETER_COUNT[this.kernelxType];
        if (parameterCount != this.parameterValuesOptimization.size()) {
            throw new OperatorException("Parameter count does not match the kernel");
        }
        Double[] parameterValues = new Double[parameterCount];
        Integer[] currentParameter = new Integer[parameterCount];
        Integer[] bestParameter = null;
        double bestHSICValue = 0.0;
        for (i = 0; i < parameterCount; ++i) {
            currentParameter[i] = 0;
        }
        block1: do {
            int n;
            Integer[] integerArray;
            for (i = 0; i < parameterCount; ++i) {
                parameterValues[i] = this.parameterValuesOptimization.get(i).get(currentParameter[i]);
            }
            this.setKernelParameters(parameterValues);
            RealMatrix kMatrix = this.hsicEstimator.computeKernelMatrix(this.x, this.kernelx, currentFeatures);
            double hsicValue = biased ? this.hsicEstimator.biasedHSIC(kMatrix, this.hlhMatrix) : this.hsicEstimator.unbiasedHSIC(kMatrix);
            if (bestParameter == null || hsicValue > bestHSICValue) {
                bestHSICValue = hsicValue;
                if (bestParameter == null) {
                    bestParameter = new Integer[parameterCount];
                }
                for (int i2 = 0; i2 < parameterCount; ++i2) {
                    bestParameter[i2] = currentParameter[i2];
                }
            }
            int k = 0;
            ok = true;
            while (((integerArray = currentParameter)[n = k] = Integer.valueOf(integerArray[n] + 1)) >= this.parameterValuesOptimization.get(k).size()) {
                currentParameter[k] = 0;
                if (++k < parameterCount) continue;
                ok = false;
                continue block1;
            }
        } while (ok);
        for (int i3 = 0; i3 < parameterCount; ++i3) {
            parameterValues[i3] = this.parameterValuesOptimization.get(i3).get(bestParameter[i3]);
        }
        this.setKernelParameters(parameterValues);
    }

    public void setKernelParameters(Double[] parameterValues) {
        switch (this.kernelxType) {
            case 1: {
                ((KernelRadial)this.kernelx).setGamma(parameterValues[0].doubleValue());
                break;
            }
            case 2: {
                ((KernelPolynomial)this.kernelx).setDegree(parameterValues[0].doubleValue());
                break;
            }
            case 3: {
                ((KernelNeural)this.kernelx).setParameters(parameterValues[0].doubleValue(), parameterValues[1].doubleValue());
                break;
            }
            case 4: {
                ((KernelAnova)this.kernelx).setParameters(parameterValues[0].doubleValue(), parameterValues[1].doubleValue());
                break;
            }
            case 5: {
                ((KernelEpanechnikov)this.kernelx).setParameters(parameterValues[0].doubleValue(), parameterValues[1].doubleValue());
                break;
            }
            case 6: {
                ((KernelGaussianCombination)this.kernelx).setParameters(parameterValues[0].doubleValue(), parameterValues[1].doubleValue(), parameterValues[2].doubleValue());
                break;
            }
            case 7: {
                ((KernelMultiquadric)this.kernelx).setParameters(parameterValues[0].doubleValue(), parameterValues[1].doubleValue());
                break;
            }
        }
    }

    public void setParametersToOptimize(Vector<Vector<Double>> parameterValuesOptimization, boolean optimize) throws OperatorException {
        this.optimize = optimize;
        if (!optimize) {
            return;
        }
        if (BAHSICOperator.PARAMETER_COUNT[this.kernelxType].intValue() != parameterValuesOptimization.size()) {
            throw new OperatorException("Parameter count does not match the kernel");
        }
        this.parameterValuesOptimization = parameterValuesOptimization;
    }

    public Vector<Attribute> getLabels(ExampleSet exampleSet) {
        Vector<Attribute> labelVector = new Vector<Attribute>();
        Iterator iterRole = exampleSet.getAttributes().specialAttributes();
        while (iterRole.hasNext()) {
            AttributeRole attributeRole = (AttributeRole)iterRole.next();
            if (!attributeRole.getSpecialName().startsWith("label")) continue;
            labelVector.add(attributeRole.getAttribute());
        }
        return labelVector;
    }

    public ExampleSet computeExampleSetBest() {
        this.exampleSetBest = (ExampleSet)this.exampleSet.copy();
        if (this.desiredFeatures >= this.xcols) {
            return this.exampleSetBest;
        }
        for (int j = 0; j < this.xcols - this.desiredFeatures; ++j) {
            this.exampleSetBest.getAttributes().remove(this.allAttributes.get(this.eliminatedFeatures.get(j)));
        }
        return this.exampleSetBest;
    }

    public AttributeWeights computeWeights() {
        AttributeWeights weights = new AttributeWeights(this.exampleSet);
        for (int j = 0; j < this.xcols; ++j) {
            weights.setWeight(this.allAttributes.get(this.eliminatedFeatures.get(j)).getName(), (double)j);
        }
        return weights;
    }
}

