/*
 * Decompiled with CFR 0.152.
 */
package timeseriesclustering.experiments;

import java.util.ArrayList;
import timeseriesclustering.dataimport.TimeSeriesLoader;

public class PermutationValidator {
    private double permute(TimeSeriesLoader loader, ArrayList<ArrayList<Double[]>> cluster, double sumsoFar, double bestSoFar, ArrayList<Double> permutation) {
        if (permutation.size() == loader.cluster.keySet().size()) {
            return Math.max(bestSoFar, sumsoFar);
        }
        int i = 0;
        for (Double d : loader.cluster.keySet()) {
            if (!permutation.contains(d)) {
                int rightCount = 0;
                for (Double[] ts : cluster.get(permutation.size())) {
                    if (loader.classes.get(ts).intValue() != d.intValue()) continue;
                    ++rightCount;
                }
                permutation.add(d);
                bestSoFar = this.permute(loader, cluster, sumsoFar + (double)rightCount, bestSoFar, permutation);
                permutation.remove(d);
            }
            ++i;
        }
        return bestSoFar;
    }

    public double validate(TimeSeriesLoader loader, ArrayList<ArrayList<Double[]>> cluster) {
        int count = 0;
        for (ArrayList<Double[]> a : cluster) {
            for (Double[] ts : a) {
                ++count;
            }
        }
        return this.permute(loader, cluster, 0.0, 0.0, new ArrayList<Double>()) / (double)count * 1.0;
    }
}

