/*
 * Decompiled with CFR 0.152.
 */
package timeseriesclustering;

import java.util.List;
import timeseriesclustering.DTW;
import timeseriesclustering.DTWInformation;
import timeseriesclustering.GlobalConstraint;

public class Query {
    public int id;
    public DTWInformation dtw;
    public Double[] ts;
    public Double[] q;

    public Query(List<Double[]> database, Double[] q, GlobalConstraint con) {
        this.q = q;
        DTWInformation bestSoFar = new DTWInformation(Double.POSITIVE_INFINITY, null);
        int bestCandidate = 0;
        Double[] u = new Double[]{};
        Double[] l = new Double[]{};
        for (int i = 0; i < database.size(); ++i) {
            Double[][] upperAndLowerBoundSeries;
            double lb_keogh2;
            double lb_keogh;
            Double[] c = database.get(i);
            if (!(DTW.lb_kim_FL(c, q) < bestSoFar.distance)) continue;
            if (c.length != u.length) {
                Double[][] upperAndLowerBoundSeries2 = DTW.upperAndLowerBoundSeries(q, c, con);
                u = upperAndLowerBoundSeries2[0];
                l = upperAndLowerBoundSeries2[1];
            }
            if (!((lb_keogh = DTW.lb_keogh(c, u, l, bestSoFar.distance)) < bestSoFar.distance) || !((lb_keogh2 = DTW.lb_keogh(q, (upperAndLowerBoundSeries = DTW.upperAndLowerBoundSeries(c, q, con))[0], upperAndLowerBoundSeries[1], bestSoFar.distance)) < bestSoFar.distance)) continue;
            DTWInformation dtwInformation = DTW.dtw(q, c, bestSoFar.distance, lb_keogh2, upperAndLowerBoundSeries[0], upperAndLowerBoundSeries[1], con);
            if (!(dtwInformation.distance < bestSoFar.distance)) continue;
            bestSoFar = dtwInformation;
            bestCandidate = i;
        }
        this.id = bestCandidate;
        this.dtw = bestSoFar;
        this.ts = database.get(this.id);
    }

    public Query(List<Double[]> database, GlobalConstraint con) {
        DTWInformation bestSoFar = new DTWInformation(Double.POSITIVE_INFINITY, null);
        int bestCandidate = 0;
        for (int i = 0; i < database.size(); ++i) {
            Double[] q = database.get(i);
            Double[] u = new Double[]{};
            Double[] l = new Double[]{};
            for (int j = i + 1; j < database.size(); ++j) {
                Double[][] upperAndLowerBoundSeries;
                double lb_keogh2;
                double lb_keogh;
                Double[] c = database.get(j);
                if (!(DTW.lb_kim_FL(c, q) < bestSoFar.distance)) continue;
                if (c.length != u.length) {
                    Double[][] upperAndLowerBoundSeries2 = DTW.upperAndLowerBoundSeries(q, c, con);
                    u = upperAndLowerBoundSeries2[0];
                    l = upperAndLowerBoundSeries2[1];
                }
                if (!((lb_keogh = DTW.lb_keogh(c, u, l, bestSoFar.distance)) < bestSoFar.distance) || !((lb_keogh2 = DTW.lb_keogh(q, (upperAndLowerBoundSeries = DTW.upperAndLowerBoundSeries(c, q, con))[0], upperAndLowerBoundSeries[1], bestSoFar.distance)) < bestSoFar.distance)) continue;
                DTWInformation dtwInformation = DTW.dtw(q, c, bestSoFar.distance, lb_keogh2, upperAndLowerBoundSeries[0], upperAndLowerBoundSeries[1], con);
                if (!(dtwInformation.distance < bestSoFar.distance)) continue;
                bestSoFar = dtwInformation;
                bestCandidate = i;
                this.q = q;
                this.ts = c;
            }
        }
        this.id = bestCandidate;
        this.dtw = bestSoFar;
    }
}

