/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.xpath;

import com.ximpleware.Expr;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;

public class LiteralExpr
extends Expr {
    public String s;

    public LiteralExpr(String string) {
        this.s = string;
    }

    @Override
    public String toString() {
        boolean bl = true;
        for (int i = 0; i < this.s.length(); ++i) {
            if (this.s.charAt(i) != '\'') continue;
            bl = false;
            break;
        }
        if (bl) {
            return "\"" + this.s + "\"";
        }
        return "'" + this.s + "'";
    }

    @Override
    public boolean evalBoolean(VTDNav vTDNav) {
        return this.s.length() != 0;
    }

    @Override
    public double evalNumber(VTDNav vTDNav) {
        try {
            double d = Double.parseDouble(this.s);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    @Override
    public int evalNodeSet(VTDNav vTDNav) throws XPathEvalException {
        throw new XPathEvalException("LiteralExpr can't eval to a node set!");
    }

    @Override
    public String evalString(VTDNav vTDNav) {
        return this.s;
    }

    @Override
    public void reset(VTDNav vTDNav) {
    }

    @Override
    public boolean isNodeSet() {
        return false;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean requireContextSize() {
        return false;
    }

    @Override
    public void setContextSize(int n) {
    }

    @Override
    public void setPosition(int n) {
    }

    @Override
    public int adjust(int n) {
        return 0;
    }
}

