/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.ContextBuffer;
import com.ximpleware.FastIntBuffer;
import com.ximpleware.FastLongBuffer;
import com.ximpleware.IByteBuffer;
import com.ximpleware.IndexHandler;
import com.ximpleware.IndexWriteException;
import com.ximpleware.NavException;
import com.ximpleware.VTDNav;
import java.io.IOException;
import java.io.OutputStream;

public class VTDNav_L5
extends VTDNav {
    protected int l4index;
    protected int l5index;
    protected int l4upper;
    protected int l4lower;
    protected int l5upper;
    protected int l5lower;
    protected FastLongBuffer l3Buffer;
    protected FastLongBuffer l4Buffer;
    protected FastIntBuffer l5Buffer;

    protected VTDNav_L5(int n, int n2, boolean bl, int n3, IByteBuffer iByteBuffer, FastLongBuffer fastLongBuffer, FastLongBuffer fastLongBuffer2, FastLongBuffer fastLongBuffer3, FastLongBuffer fastLongBuffer4, FastLongBuffer fastLongBuffer5, FastIntBuffer fastIntBuffer, int n4, int n5) {
        if (fastLongBuffer2 == null || fastLongBuffer3 == null || fastLongBuffer4 == null || fastLongBuffer == null || iByteBuffer == null || n3 < 0 || n < 0 || n4 < 0 || n5 < 0) {
            throw new IllegalArgumentException();
        }
        this.l1Buffer = fastLongBuffer2;
        this.l2Buffer = fastLongBuffer3;
        this.l3Buffer = fastLongBuffer4;
        this.l4Buffer = fastLongBuffer5;
        this.l5Buffer = fastIntBuffer;
        this.vtdBuffer = fastLongBuffer;
        this.XMLDoc = iByteBuffer;
        this.encoding = n2;
        this.rootIndex = n;
        this.nestingLevel = n3 + 1;
        this.ns = bl;
        MASK_TOKEN_OFFSET = !this.ns ? Integer.MAX_VALUE : 0x3FFFFFFFL;
        this.atTerminal = false;
        this.context = new int[this.nestingLevel];
        this.context[0] = 0;
        for (int i = 1; i < this.nestingLevel; ++i) {
            this.context[i] = -1;
        }
        this.contextStack = new ContextBuffer(10, this.nestingLevel + 15);
        this.contextStack2 = new ContextBuffer(10, this.nestingLevel + 15);
        this.stackTemp = new int[this.nestingLevel + 15];
        this.l5index = -1;
        this.l4index = -1;
        this.l3index = -1;
        this.l2index = -1;
        this.l1index = -1;
        this.l5lower = -1;
        this.l4lower = -1;
        this.l3lower = -1;
        this.l2lower = -1;
        this.l5upper = -1;
        this.l4upper = -1;
        this.l3upper = -1;
        this.l2upper = -1;
        this.docOffset = n4;
        this.docLen = n5;
        this.vtdSize = fastLongBuffer.size;
        this.name = null;
        this.nameIndex = -1;
        this.localName = null;
        this.localNameIndex = -1;
        this.fib = new FastIntBuffer(5);
        this.shallowDepth = false;
        this.maxLCDepthPlusOne = (short)6;
    }

    @Override
    public VTDNav cloneNav() {
        VTDNav_L5 vTDNav_L5 = new VTDNav_L5(this.rootIndex, this.encoding, this.ns, this.nestingLevel - 1, this.XMLDoc, this.vtdBuffer, this.l1Buffer, this.l2Buffer, this.l3Buffer, this.l4Buffer, this.l5Buffer, this.docOffset, this.docLen);
        vTDNav_L5.atTerminal = this.atTerminal;
        vTDNav_L5.LN = this.LN;
        if (this.context[0] != -1) {
            System.arraycopy(this.context, 0, vTDNav_L5.context, 0, this.context[0] + 1);
        } else {
            vTDNav_L5.context[0] = -1;
        }
        vTDNav_L5.l1index = this.l1index;
        if (this.getCurrentDepth() > 1) {
            vTDNav_L5.l2index = this.l2index;
            vTDNav_L5.l2upper = this.l2upper;
            vTDNav_L5.l2lower = this.l2lower;
        }
        if (this.getCurrentDepth() > 2) {
            vTDNav_L5.l3lower = this.l3lower;
            vTDNav_L5.l3index = this.l3index;
            vTDNav_L5.l3upper = this.l3upper;
        }
        if (this.getCurrentDepth() > 3) {
            vTDNav_L5.l4lower = this.l4lower;
            vTDNav_L5.l4index = this.l4index;
            vTDNav_L5.l4upper = this.l4upper;
        }
        if (this.getCurrentDepth() > 4) {
            vTDNav_L5.l5lower = this.l5lower;
            vTDNav_L5.l5index = this.l5index;
            vTDNav_L5.l5upper = this.l5upper;
        }
        return vTDNav_L5;
    }

    @Override
    public final VTDNav duplicateNav() {
        return new VTDNav_L5(this.rootIndex, this.encoding, this.ns, this.nestingLevel - 1, this.XMLDoc, this.vtdBuffer, this.l1Buffer, this.l2Buffer, this.l3Buffer, this.l4Buffer, this.l5Buffer, this.docOffset, this.docLen);
    }

    @Override
    protected final boolean iterateNS(int n, String string, String string2) throws NavException {
        if (!this.ns) {
            return false;
        }
        int n2 = this.getCurrentIndex() + 1;
        while (n2 < this.vtdSize) {
            int n3 = this.getTokenType(n2);
            if (n3 == 2 || n3 == 3) {
                n2 += 2;
                continue;
            }
            if (this.isElementOrDocument(n2)) {
                int n4 = this.getTokenDepth(n2);
                if (n4 > n) {
                    this.context[0] = n4;
                    if (n4 > 0) {
                        this.context[n4] = n2;
                    }
                    if (this.matchElementNS(string, string2)) {
                        if (n < 6) {
                            this.resolveLC();
                        }
                        return true;
                    }
                } else {
                    return false;
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void resolveLC() {
        if (this.context[0] <= 0) {
            return;
        }
        this.resolveLC_l1();
        if (this.context[0] == 1) {
            return;
        }
        this.resolveLC_l2();
        if (this.context[0] == 2) {
            return;
        }
        this.resolveLC_l3();
        if (this.context[0] == 3) {
            return;
        }
        this.resolveLC_l4();
        if (this.context[0] == 4) {
            return;
        }
        this.resolveLC_l5();
    }

    @Override
    protected void resolveLC_l3() {
        block16: {
            int n;
            int n2 = this.l2Buffer.lower32At(this.l2index);
            if (this.l3lower != n2) {
                this.l3index = this.l3lower = n2;
                this.l3upper = this.l3Buffer.size - 1;
                for (n = this.l2index + 1; n < this.l2Buffer.size; ++n) {
                    n2 = this.l2Buffer.lower32At(n);
                    if (n2 == -1) continue;
                    this.l3upper = n2 - 1;
                    break;
                }
            }
            if (this.l3index >= 0 && this.l3index < this.l3Buffer.size && this.context[3] == this.l3Buffer.upper32At(this.l3index)) break block16;
            if (this.l3index >= this.l3Buffer.size || this.l3index < 0) {
                this.l3index = this.l3lower;
            }
            if (this.l3index + 1 < this.l3Buffer.size && this.context[3] == this.l3Buffer.upper32At(this.l3index + 1)) {
                ++this.l3index;
            } else if (this.l3upper - this.l3lower >= 16) {
                n = this.l3lower + (int)((float)(this.l3upper - this.l3lower) * ((float)this.context[3] - (float)this.l3Buffer.upper32At(this.l3lower)) / (float)(this.l3Buffer.upper32At(this.l3upper) - this.l3Buffer.upper32At(this.l3lower)));
                if (this.l3Buffer.upper32At(n) > this.context[3]) {
                    while (this.context[3] != this.l3Buffer.upper32At(n)) {
                        --n;
                    }
                } else if (this.l3Buffer.upper32At(n) < this.context[3]) {
                    while (this.context[3] != this.l3Buffer.upper32At(n)) {
                        ++n;
                    }
                }
                this.l3index = n;
            } else if (this.context[3] < this.l3Buffer.upper32At(this.l3index)) {
                while (this.context[3] != this.l3Buffer.upper32At(this.l3index)) {
                    --this.l3index;
                }
            } else {
                while (this.context[3] != this.l3Buffer.upper32At(this.l3index)) {
                    ++this.l3index;
                }
            }
        }
    }

    private void resolveLC_l4() {
        block16: {
            int n;
            int n2 = this.l3Buffer.lower32At(this.l3index);
            if (this.l4lower != n2) {
                this.l4index = this.l4lower = n2;
                this.l4upper = this.l4Buffer.size - 1;
                for (n = this.l3index + 1; n < this.l3Buffer.size; ++n) {
                    n2 = this.l3Buffer.lower32At(n);
                    if (n2 == -1) continue;
                    this.l4upper = n2 - 1;
                    break;
                }
            }
            if (this.l4index >= 0 && this.l4index < this.l4Buffer.size && this.context[4] == this.l4Buffer.upper32At(this.l4index)) break block16;
            if (this.l4index >= this.l4Buffer.size || this.l4index < 0) {
                this.l4index = this.l4lower;
            }
            if (this.l4index + 1 < this.l4Buffer.size && this.context[4] == this.l4Buffer.upper32At(this.l4index + 1)) {
                ++this.l4index;
            } else if (this.l4upper - this.l4lower >= 16) {
                n = this.l4lower + (int)((float)(this.l4upper - this.l4lower) * ((float)this.context[4] - (float)this.l4Buffer.upper32At(this.l4lower)) / (float)(this.l4Buffer.upper32At(this.l4upper) - this.l4Buffer.upper32At(this.l4lower)));
                if (this.l4Buffer.upper32At(n) > this.context[4]) {
                    while (this.context[4] != this.l4Buffer.upper32At(n)) {
                        --n;
                    }
                } else if (this.l4Buffer.upper32At(n) < this.context[4]) {
                    while (this.context[4] != this.l4Buffer.upper32At(n)) {
                        ++n;
                    }
                }
                this.l4index = n;
            } else if (this.context[4] < this.l4Buffer.upper32At(this.l4index)) {
                while (this.context[4] != this.l4Buffer.upper32At(this.l4index)) {
                    --this.l4index;
                }
            } else {
                while (this.context[4] != this.l4Buffer.upper32At(this.l4index)) {
                    ++this.l4index;
                }
            }
        }
    }

    private void resolveLC_l5() {
        block16: {
            int n;
            int n2 = this.l4Buffer.lower32At(this.l4index);
            if (this.l5lower != n2) {
                this.l5index = this.l5lower = n2;
                this.l5upper = this.l5Buffer.size - 1;
                for (n = this.l4index + 1; n < this.l4Buffer.size; ++n) {
                    n2 = this.l4Buffer.lower32At(n);
                    if (n2 == -1) continue;
                    this.l5upper = n2 - 1;
                    break;
                }
            }
            if (this.l5index >= 0 && this.l5index < this.l5Buffer.size && this.context[5] == this.l5Buffer.intAt(this.l5index)) break block16;
            if (this.l5index >= this.l5Buffer.size || this.l5index < 0) {
                this.l5index = this.l5lower;
            }
            if (this.l5index + 1 < this.l5Buffer.size && this.context[5] == this.l5Buffer.intAt(this.l5index + 1)) {
                ++this.l5index;
            } else if (this.l5upper - this.l5lower >= 16) {
                n = this.l5lower + (int)((float)(this.l5upper - this.l5lower) * ((float)(this.context[5] - this.l5Buffer.intAt(this.l5lower)) / (float)(this.l5Buffer.intAt(this.l5upper) - this.l5Buffer.intAt(this.l5lower))));
                if (this.l5Buffer.intAt(n) > this.context[5]) {
                    while (this.context[5] != this.l5Buffer.intAt(n)) {
                        --n;
                    }
                } else if (this.l5Buffer.intAt(n) < this.context[5]) {
                    while (this.context[5] != this.l5Buffer.intAt(n)) {
                        ++n;
                    }
                }
                this.l5index = n;
            } else if (this.context[5] < this.l5Buffer.intAt(this.l5index)) {
                while (this.context[5] != this.l5Buffer.intAt(this.l5index)) {
                    --this.l5index;
                }
            } else {
                while (this.context[5] != this.l5Buffer.intAt(this.l5index)) {
                    ++this.l5index;
                }
            }
        }
    }

    @Override
    public boolean pop() {
        boolean bl = this.contextStack.load(this.stackTemp);
        if (!bl) {
            return false;
        }
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.context[i] = this.stackTemp[i];
        }
        this.l1index = this.stackTemp[this.nestingLevel];
        this.l2index = this.stackTemp[this.nestingLevel + 1];
        this.l3index = this.stackTemp[this.nestingLevel + 2];
        this.l4index = this.stackTemp[this.nestingLevel + 3];
        this.l5index = this.stackTemp[this.nestingLevel + 4];
        this.l2lower = this.stackTemp[this.nestingLevel + 5];
        this.l2upper = this.stackTemp[this.nestingLevel + 6];
        this.l3lower = this.stackTemp[this.nestingLevel + 7];
        this.l3upper = this.stackTemp[this.nestingLevel + 8];
        this.l4lower = this.stackTemp[this.nestingLevel + 9];
        this.l4upper = this.stackTemp[this.nestingLevel + 10];
        this.l5lower = this.stackTemp[this.nestingLevel + 11];
        this.l5upper = this.stackTemp[this.nestingLevel + 12];
        this.atTerminal = this.stackTemp[this.nestingLevel + 13] == 1;
        this.LN = this.stackTemp[this.nestingLevel + 14];
        return true;
    }

    @Override
    protected final boolean pop2() {
        boolean bl = this.contextStack2.load(this.stackTemp);
        if (!bl) {
            return false;
        }
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.context[i] = this.stackTemp[i];
        }
        this.l1index = this.stackTemp[this.nestingLevel];
        this.l2index = this.stackTemp[this.nestingLevel + 1];
        this.l3index = this.stackTemp[this.nestingLevel + 2];
        this.l4index = this.stackTemp[this.nestingLevel + 3];
        this.l5index = this.stackTemp[this.nestingLevel + 4];
        this.l2lower = this.stackTemp[this.nestingLevel + 5];
        this.l2upper = this.stackTemp[this.nestingLevel + 6];
        this.l3lower = this.stackTemp[this.nestingLevel + 7];
        this.l3upper = this.stackTemp[this.nestingLevel + 8];
        this.l4lower = this.stackTemp[this.nestingLevel + 9];
        this.l4upper = this.stackTemp[this.nestingLevel + 10];
        this.l5lower = this.stackTemp[this.nestingLevel + 11];
        this.l5upper = this.stackTemp[this.nestingLevel + 12];
        this.atTerminal = this.stackTemp[this.nestingLevel + 13] == 1;
        this.LN = this.stackTemp[this.nestingLevel + 14];
        return true;
    }

    @Override
    public final void push() {
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.stackTemp[i] = this.context[i];
        }
        this.stackTemp[this.nestingLevel] = this.l1index;
        this.stackTemp[this.nestingLevel + 1] = this.l2index;
        this.stackTemp[this.nestingLevel + 2] = this.l3index;
        this.stackTemp[this.nestingLevel + 3] = this.l4index;
        this.stackTemp[this.nestingLevel + 4] = this.l5index;
        this.stackTemp[this.nestingLevel + 5] = this.l2lower;
        this.stackTemp[this.nestingLevel + 6] = this.l2upper;
        this.stackTemp[this.nestingLevel + 7] = this.l3lower;
        this.stackTemp[this.nestingLevel + 8] = this.l3upper;
        this.stackTemp[this.nestingLevel + 9] = this.l4lower;
        this.stackTemp[this.nestingLevel + 10] = this.l4upper;
        this.stackTemp[this.nestingLevel + 11] = this.l5lower;
        this.stackTemp[this.nestingLevel + 12] = this.l5upper;
        this.stackTemp[this.nestingLevel + 13] = this.atTerminal ? 1 : 0;
        this.stackTemp[this.nestingLevel + 14] = this.LN;
        this.contextStack.store(this.stackTemp);
    }

    @Override
    protected final void push2() {
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.stackTemp[i] = this.context[i];
        }
        this.stackTemp[this.nestingLevel] = this.l1index;
        this.stackTemp[this.nestingLevel + 1] = this.l2index;
        this.stackTemp[this.nestingLevel + 2] = this.l3index;
        this.stackTemp[this.nestingLevel + 3] = this.l4index;
        this.stackTemp[this.nestingLevel + 4] = this.l5index;
        this.stackTemp[this.nestingLevel + 5] = this.l2lower;
        this.stackTemp[this.nestingLevel + 6] = this.l2upper;
        this.stackTemp[this.nestingLevel + 7] = this.l3lower;
        this.stackTemp[this.nestingLevel + 8] = this.l3upper;
        this.stackTemp[this.nestingLevel + 9] = this.l4lower;
        this.stackTemp[this.nestingLevel + 10] = this.l4upper;
        this.stackTemp[this.nestingLevel + 11] = this.l5lower;
        this.stackTemp[this.nestingLevel + 12] = this.l5upper;
        this.stackTemp[this.nestingLevel + 13] = this.atTerminal ? 1 : 0;
        this.stackTemp[this.nestingLevel + 14] = this.LN;
        this.contextStack2.store(this.stackTemp);
    }

    private final void recoverNode_l3(int n) {
        int n2;
        int n3 = this.l2Buffer.lower32At(this.l2index);
        if (this.l3lower != n3) {
            this.l3lower = n3;
            this.l3upper = this.l3Buffer.size - 1;
            for (n2 = this.l2index + 1; n2 < this.l2Buffer.size; ++n2) {
                n3 = this.l2Buffer.lower32At(n2);
                if (n3 == -1) continue;
                this.l3upper = n3 - 1;
                break;
            }
        }
        n2 = this.l3Buffer.upper32At(this.l3lower);
        int n4 = this.l3Buffer.upper32At(this.l3upper);
        for (n3 = Math.min(this.l3lower + (int)((float)(n - n2) / (float)(n4 - n2 + 1) * (float)(this.l3upper - this.l3lower)), this.l3upper); n3 < this.l3Buffer.size - 1 && this.l3Buffer.upper32At(n3) < n; ++n3) {
        }
        while (this.l3Buffer.upper32At(n3) > n && n3 > 0) {
            --n3;
        }
        this.context[3] = this.l3Buffer.upper32At(n3);
        this.l3index = n3;
    }

    private final void recoverNode_l4(int n) {
        int n2;
        int n3 = this.l3Buffer.lower32At(this.l3index);
        if (this.l4lower != n3) {
            this.l4lower = n3;
            this.l4upper = this.l4Buffer.size - 1;
            for (n2 = this.l3index + 1; n2 < this.l3Buffer.size; ++n2) {
                n3 = this.l3Buffer.lower32At(n2);
                if (n3 == -1) continue;
                this.l4upper = n3 - 1;
                break;
            }
        }
        n2 = this.l4Buffer.upper32At(this.l4lower);
        int n4 = this.l4Buffer.upper32At(this.l4upper);
        for (n3 = Math.min(this.l4lower + (int)((float)(n - n2) / (float)(n4 - n2 + 1) * (float)(this.l4upper - this.l4lower)), this.l4upper); n3 < this.l4Buffer.size - 1 && this.l4Buffer.upper32At(n3) < n; ++n3) {
        }
        while (this.l4Buffer.upper32At(n3) > n && n3 > 0) {
            --n3;
        }
        this.context[4] = this.l4Buffer.upper32At(n3);
        this.l4index = n3;
    }

    private final void recoverNode_l5(int n) {
        int n2;
        int n3 = this.l4Buffer.lower32At(this.l4index);
        if (this.l5lower != n3) {
            this.l5lower = n3;
            this.l5upper = this.l5Buffer.size - 1;
            for (n2 = this.l4index + 1; n2 < this.l4Buffer.size; ++n2) {
                n3 = this.l4Buffer.lower32At(n2);
                if (n3 == -1) continue;
                this.l5upper = n3 - 1;
                break;
            }
        }
        n2 = this.l5Buffer.intAt(this.l5lower);
        int n4 = this.l5Buffer.intAt(this.l5upper);
        for (n3 = Math.min(this.l5lower + (int)((float)(n - n2) / (float)(n4 - n2 + 1) * (float)(this.l5upper - this.l5lower)), this.l5upper); n3 < this.l5Buffer.size - 1 && this.l5Buffer.intAt(n3) < n; ++n3) {
        }
        while (this.l5Buffer.intAt(n3) > n && n3 > 0) {
            --n3;
        }
        this.context[5] = this.l5Buffer.intAt(n3);
        this.l5index = n3;
    }

    @Override
    public void sampleState(FastIntBuffer fastIntBuffer) {
        if (this.context[0] >= 1) {
            fastIntBuffer.append(this.l1index);
        }
        if (this.context[0] >= 2) {
            fastIntBuffer.append(this.l2index);
            fastIntBuffer.append(this.l2lower);
            fastIntBuffer.append(this.l2upper);
        }
        if (this.context[0] >= 3) {
            fastIntBuffer.append(this.l3index);
            fastIntBuffer.append(this.l3lower);
            fastIntBuffer.append(this.l3upper);
        }
        if (this.context[0] >= 4) {
            fastIntBuffer.append(this.l4index);
            fastIntBuffer.append(this.l4lower);
            fastIntBuffer.append(this.l4upper);
        }
        if (this.context[0] >= 5) {
            fastIntBuffer.append(this.l5index);
            fastIntBuffer.append(this.l5lower);
            fastIntBuffer.append(this.l5upper);
        }
    }

    @Override
    public boolean toElement(int n, String string) throws NavException {
        int n2 = 0;
        if (string == null) {
            throw new IllegalArgumentException(" Element name can't be null ");
        }
        if (string.equals("*")) {
            return this.toElement(n);
        }
        switch (n) {
            case 0: {
                return this.toElement(0);
            }
            case 1: {
                return this.toElement(1);
            }
            case 2: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(2)) {
                    return false;
                }
                if (!this.matchElement(string)) {
                    if (this.toElement(4, string)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 3: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(3)) {
                    return false;
                }
                if (!this.matchElement(string)) {
                    if (this.toElement(5, string)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 4: {
                if (this.atTerminal) {
                    return false;
                }
                int n3 = this.context[0];
                switch (n3) {
                    case -1: 
                    case 0: {
                        return false;
                    }
                    case 1: {
                        n2 = this.l1index;
                        break;
                    }
                    case 2: {
                        n2 = this.l2index;
                        break;
                    }
                    case 3: {
                        n2 = this.l3index;
                        break;
                    }
                    case 4: {
                        n2 = this.l4index;
                        break;
                    }
                    case 5: {
                        n2 = this.l5index;
                        break;
                    }
                }
                int n4 = this.context[n3];
                while (this.toElement(4)) {
                    if (!this.matchElement(string)) continue;
                    return true;
                }
                switch (n3) {
                    case 1: {
                        this.l1index = n2;
                        break;
                    }
                    case 2: {
                        this.l2index = n2;
                        break;
                    }
                    case 3: {
                        this.l3index = n2;
                        break;
                    }
                    case 4: {
                        this.l4index = n2;
                        break;
                    }
                    case 5: {
                        this.l5index = n2;
                        break;
                    }
                }
                this.context[n3] = n4;
                return false;
            }
            case 5: {
                if (this.atTerminal) {
                    return false;
                }
                int n5 = this.context[0];
                switch (n5) {
                    case -1: 
                    case 0: {
                        return false;
                    }
                    case 1: {
                        n2 = this.l1index;
                        break;
                    }
                    case 2: {
                        n2 = this.l2index;
                        break;
                    }
                    case 3: {
                        n2 = this.l3index;
                        break;
                    }
                    case 4: {
                        n2 = this.l4index;
                        break;
                    }
                    case 5: {
                        n2 = this.l5index;
                        break;
                    }
                }
                int n6 = this.context[n5];
                while (this.toElement(5)) {
                    if (!this.matchElement(string)) continue;
                    return true;
                }
                switch (n5) {
                    case 1: {
                        this.l1index = n2;
                        break;
                    }
                    case 2: {
                        this.l2index = n2;
                        break;
                    }
                    case 3: {
                        this.l3index = n2;
                        break;
                    }
                    case 4: {
                        this.l4index = n2;
                        break;
                    }
                    case 5: {
                        this.l5index = n2;
                        break;
                    }
                }
                this.context[n5] = n6;
                return false;
            }
        }
        throw new NavException("illegal navigation options");
    }

    @Override
    public boolean toElement(int n) throws NavException {
        switch (n) {
            case 0: {
                if (this.context[0] != 0) {
                    this.context[0] = 0;
                }
                this.atTerminal = false;
                this.l3index = -1;
                this.l2index = -1;
                this.l1index = -1;
                return true;
            }
            case 1: {
                if (this.atTerminal) {
                    this.atTerminal = false;
                    return true;
                }
                if (this.context[0] > 0) {
                    this.context[this.context[0]] = -1;
                    this.context[0] = this.context[0] - 1;
                    return true;
                }
                if (this.context[0] == 0) {
                    this.context[0] = -1;
                    return true;
                }
                return false;
            }
            case 2: 
            case 3: {
                if (this.atTerminal) {
                    return false;
                }
                switch (this.context[0]) {
                    case -1: {
                        this.context[0] = 0;
                        return true;
                    }
                    case 0: {
                        if (this.l1Buffer.size > 0) {
                            this.context[0] = 1;
                            this.l1index = n == 2 ? 0 : this.l1Buffer.size - 1;
                            this.context[1] = this.l1Buffer.upper32At(this.l1index);
                            return true;
                        }
                        return false;
                    }
                    case 1: {
                        this.l2lower = this.l1Buffer.lower32At(this.l1index);
                        if (this.l2lower == -1) {
                            return false;
                        }
                        this.context[0] = 2;
                        this.l2upper = this.l2Buffer.size - 1;
                        int n2 = this.l1Buffer.size;
                        for (int i = this.l1index + 1; i < n2; ++i) {
                            int n3 = this.l1Buffer.lower32At(i);
                            if (n3 == -1) continue;
                            this.l2upper = n3 - 1;
                            break;
                        }
                        this.l2index = n == 2 ? this.l2lower : this.l2upper;
                        this.context[2] = this.l2Buffer.upper32At(this.l2index);
                        return true;
                    }
                    case 2: {
                        this.l3lower = this.l2Buffer.lower32At(this.l2index);
                        if (this.l3lower == -1) {
                            return false;
                        }
                        this.context[0] = 3;
                        this.l3upper = this.l3Buffer.size - 1;
                        int n4 = this.l2Buffer.size;
                        for (int i = this.l2index + 1; i < n4; ++i) {
                            int n5 = this.l2Buffer.lower32At(i);
                            if (n5 == -1) continue;
                            this.l3upper = n5 - 1;
                            break;
                        }
                        this.l3index = n == 2 ? this.l3lower : this.l3upper;
                        this.context[3] = this.l3Buffer.upper32At(this.l3index);
                        return true;
                    }
                    case 3: {
                        this.l4lower = this.l3Buffer.lower32At(this.l3index);
                        if (this.l4lower == -1) {
                            return false;
                        }
                        this.context[0] = 4;
                        this.l4upper = this.l4Buffer.size - 1;
                        int n6 = this.l3Buffer.size;
                        for (int i = this.l3index + 1; i < n6; ++i) {
                            int n7 = this.l3Buffer.lower32At(i);
                            if (n7 == -1) continue;
                            this.l4upper = n7 - 1;
                            break;
                        }
                        this.l4index = n == 2 ? this.l4lower : this.l4upper;
                        this.context[4] = this.l4Buffer.upper32At(this.l4index);
                        return true;
                    }
                    case 4: {
                        this.l5lower = this.l4Buffer.lower32At(this.l4index);
                        if (this.l5lower == -1) {
                            return false;
                        }
                        this.context[0] = 5;
                        this.l5upper = this.l5Buffer.size - 1;
                        int n8 = this.l4Buffer.size;
                        for (int i = this.l4index + 1; i < n8; ++i) {
                            int n9 = this.l4Buffer.lower32At(i);
                            if (n9 == -1) continue;
                            this.l5upper = n9 - 1;
                            break;
                        }
                        this.l5index = n == 2 ? this.l5lower : this.l5upper;
                        this.context[5] = this.l5Buffer.intAt(this.l5index);
                        return true;
                    }
                }
                if (n == 2) {
                    int n10 = this.vtdBuffer.size;
                    for (int i = this.context[this.context[0]] + 1; i < n10; ++i) {
                        long l = this.vtdBuffer.longAt(i);
                        int n11 = (int)((0xF000000000000000L & l) >> 60) & 0xF;
                        if (n11 != 0) continue;
                        int n12 = (int)((0xFF0000000000000L & l) >> 52);
                        if (n12 <= this.context[0]) {
                            return false;
                        }
                        if (n12 != this.context[0] + 1) continue;
                        this.context[0] = this.context[0] + 1;
                        this.context[this.context[0]] = i;
                        return true;
                    }
                    return false;
                }
                int n13 = -1;
                int n14 = this.vtdBuffer.size;
                for (int i = this.context[this.context[0]] + 1; i < n14; ++i) {
                    long l = this.vtdBuffer.longAt(i);
                    int n15 = (int)((0xFF0000000000000L & l) >> 52);
                    int n16 = (int)((0xF000000000000000L & l) >> 60) & 0xF;
                    if (n16 != 0) continue;
                    if (n15 <= this.context[0]) break;
                    if (n15 != this.context[0] + 1) continue;
                    n13 = i;
                }
                if (n13 == -1) {
                    return false;
                }
                this.context[0] = this.context[0] + 1;
                this.context[this.context[0]] = n13;
                return true;
            }
            case 4: 
            case 5: {
                if (this.atTerminal) {
                    return false;
                }
                switch (this.context[0]) {
                    case -1: 
                    case 0: {
                        return false;
                    }
                    case 1: {
                        if (n == 4) {
                            if (this.l1index + 1 >= this.l1Buffer.size) {
                                return false;
                            }
                            ++this.l1index;
                        } else {
                            if (this.l1index - 1 < 0) {
                                return false;
                            }
                            --this.l1index;
                        }
                        this.context[1] = this.l1Buffer.upper32At(this.l1index);
                        return true;
                    }
                    case 2: {
                        if (n == 4) {
                            if (this.l2index + 1 > this.l2upper) {
                                return false;
                            }
                            ++this.l2index;
                        } else {
                            if (this.l2index - 1 < this.l2lower) {
                                return false;
                            }
                            --this.l2index;
                        }
                        this.context[2] = this.l2Buffer.upper32At(this.l2index);
                        return true;
                    }
                    case 3: {
                        if (n == 4) {
                            if (this.l3index + 1 > this.l3upper) {
                                return false;
                            }
                            ++this.l3index;
                        } else {
                            if (this.l3index - 1 < this.l3lower) {
                                return false;
                            }
                            --this.l3index;
                        }
                        this.context[3] = this.l3Buffer.upper32At(this.l3index);
                        return true;
                    }
                    case 4: {
                        if (n == 4) {
                            if (this.l4index + 1 > this.l4upper) {
                                return false;
                            }
                            ++this.l4index;
                        } else {
                            if (this.l4index - 1 < this.l4lower) {
                                return false;
                            }
                            --this.l4index;
                        }
                        this.context[4] = this.l4Buffer.upper32At(this.l4index);
                        return true;
                    }
                    case 5: {
                        if (n == 4) {
                            if (this.l5index + 1 > this.l5upper) {
                                return false;
                            }
                            ++this.l5index;
                        } else {
                            if (this.l5index - 1 < this.l5lower) {
                                return false;
                            }
                            --this.l5index;
                        }
                        this.context[5] = this.l5Buffer.intAt(this.l5index);
                        return true;
                    }
                }
                if (n == 4) {
                    int n17 = this.vtdBuffer.size;
                    for (int i = this.context[this.context[0]] + 1; i < n17; ++i) {
                        long l = this.vtdBuffer.longAt(i);
                        int n18 = (int)((0xF000000000000000L & l) >> 60) & 0xF;
                        if (n18 != 0) continue;
                        int n19 = (int)((0xFF0000000000000L & l) >> 52);
                        if (n19 < this.context[0]) {
                            return false;
                        }
                        if (n19 != this.context[0]) continue;
                        this.context[this.context[0]] = i;
                        return true;
                    }
                    return false;
                }
                for (int i = this.context[this.context[0]] - 1; i > this.context[this.context[0] - 1]; --i) {
                    int n20;
                    long l = this.vtdBuffer.longAt(i);
                    int n21 = (int)((0xF000000000000000L & l) >> 60) & 0xF;
                    if (n21 != 0 || (n20 = (int)((0xFF0000000000000L & l) >> 52)) != this.context[0]) continue;
                    this.context[this.context[0]] = i;
                    return true;
                }
                return false;
            }
        }
        throw new NavException("illegal navigation options");
    }

    @Override
    public boolean toElementNS(int n, String string, String string2) throws NavException {
        int n2 = 0;
        if (!this.ns) {
            return false;
        }
        switch (n) {
            case 0: {
                return this.toElement(0);
            }
            case 1: {
                return this.toElement(1);
            }
            case 2: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(2)) {
                    return false;
                }
                if (!this.matchElementNS(string, string2)) {
                    if (this.toElementNS(4, string, string2)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 3: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(3)) {
                    return false;
                }
                if (!this.matchElementNS(string, string2)) {
                    if (this.toElementNS(5, string, string2)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 4: {
                if (this.atTerminal) {
                    return false;
                }
                int n3 = this.context[0];
                int n4 = this.context[n3];
                switch (n3) {
                    case -1: 
                    case 0: {
                        return false;
                    }
                    case 1: {
                        n2 = this.l1index;
                        break;
                    }
                    case 2: {
                        n2 = this.l2index;
                        break;
                    }
                    case 3: {
                        n2 = this.l3index;
                        break;
                    }
                    case 4: {
                        n2 = this.l4index;
                        break;
                    }
                    case 5: {
                        n2 = this.l5index;
                        break;
                    }
                }
                while (this.toElement(4)) {
                    if (!this.matchElementNS(string, string2)) continue;
                    return true;
                }
                switch (n3) {
                    case 1: {
                        this.l1index = n2;
                        break;
                    }
                    case 2: {
                        this.l2index = n2;
                        break;
                    }
                    case 3: {
                        this.l3index = n2;
                        break;
                    }
                    case 4: {
                        n2 = this.l4index;
                        break;
                    }
                    case 5: {
                        n2 = this.l5index;
                        break;
                    }
                }
                this.context[n3] = n4;
                return false;
            }
            case 5: {
                if (this.atTerminal) {
                    return false;
                }
                int n5 = this.context[0];
                int n6 = this.context[n5];
                switch (n5) {
                    case -1: 
                    case 0: {
                        return false;
                    }
                    case 1: {
                        n2 = this.l1index;
                        break;
                    }
                    case 2: {
                        n2 = this.l2index;
                        break;
                    }
                    case 3: {
                        n2 = this.l3index;
                        break;
                    }
                    case 4: {
                        n2 = this.l4index;
                        break;
                    }
                    case 5: {
                        n2 = this.l5index;
                        break;
                    }
                }
                while (this.toElement(5)) {
                    if (!this.matchElementNS(string, string2)) continue;
                    return true;
                }
                switch (n5) {
                    case 1: {
                        this.l1index = n2;
                        break;
                    }
                    case 2: {
                        this.l2index = n2;
                        break;
                    }
                    case 3: {
                        this.l3index = n2;
                        break;
                    }
                    case 4: {
                        n2 = this.l4index;
                        break;
                    }
                    case 5: {
                        n2 = this.l5index;
                        break;
                    }
                }
                this.context[n5] = n6;
                return false;
            }
        }
        throw new NavException("illegal navigation options");
    }

    @Override
    public void recoverNode(int n) throws NavException {
        int n2;
        if (n < 0 || n >= this.vtdSize) {
            throw new NavException("Invalid VTD index");
        }
        int n3 = this.getTokenType(n);
        if (n3 == 8 || n3 == 9 || n3 == 10 || n3 == 4) {
            throw new NavException("Token type not yet supported");
        }
        int n4 = this.getTokenDepth(n);
        switch (n4) {
            case -1: {
                this.context[0] = -1;
                if (n != 0) {
                    this.LN = n;
                    this.atTerminal = true;
                }
                return;
            }
            case 0: {
                this.context[0] = 0;
                if (n != this.rootIndex) {
                    this.LN = n;
                    this.atTerminal = true;
                }
                return;
            }
        }
        this.context[0] = n4;
        if (n3 != 0) {
            this.LN = n;
            this.atTerminal = true;
        }
        this.recoverNode_l1(n);
        if (n4 == 1) {
            return;
        }
        this.recoverNode_l2(n);
        if (n4 == 2) {
            return;
        }
        this.recoverNode_l3(n);
        if (n4 == 3) {
            return;
        }
        this.recoverNode_l4(n);
        if (n4 == 4) {
            return;
        }
        this.recoverNode_l5(n);
        if (n4 == 5) {
            return;
        }
        if (n3 == 0) {
            this.context[n4] = n;
        } else {
            n2 = n - 1;
            while (this.getTokenType(n2) != 0 || this.getTokenDepth(n2) != n4) {
                --n2;
            }
            this.context[n4] = n2;
        }
        n2 = this.context[n4] - 1;
        --n4;
        while (n4 > 5) {
            while (this.getTokenType(n2) != 0 || this.getTokenDepth(n2) != n4) {
                --n2;
            }
            this.context[n4] = n2;
            --n4;
        }
    }

    @Override
    public void writeIndex(OutputStream outputStream) throws IndexWriteException, IOException {
        IndexHandler.writeIndex_L5((byte)1, this.encoding, this.ns, true, this.nestingLevel - 1, 5, this.rootIndex, this.XMLDoc.getBytes(), this.docOffset, this.docLen, this.vtdBuffer, this.l1Buffer, this.l2Buffer, this.l3Buffer, this.l4Buffer, this.l5Buffer, outputStream);
    }

    @Override
    public void writeSeparateIndex(OutputStream outputStream) throws IndexWriteException, IOException {
        IndexHandler.writeSeparateIndex_L5((byte)2, this.encoding, this.ns, true, this.nestingLevel - 1, 5, this.rootIndex, this.docOffset, this.docLen, this.vtdBuffer, this.l1Buffer, this.l2Buffer, this.l3Buffer, this.l4Buffer, this.l5Buffer, outputStream);
    }
}

