/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.Expr;
import com.ximpleware.FastIntBuffer;
import com.ximpleware.NavException;
import com.ximpleware.PilotException;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import com.ximpleware.xpath.parser;
import java.io.StringReader;
import java.util.Hashtable;

public class AutoPilot {
    private int depth;
    private int iter_type;
    private VTDNav vn;
    private int index;
    private boolean ft;
    private boolean special;
    private String name;
    private String name2;
    private String localName;
    private String URL;
    private int size;
    private Expr xpe;
    private int[] contextCopy;
    private int stackSize;
    private FastIntBuffer fib;
    private static Hashtable nsHash;
    public static final int UNDEFINED = 0;
    public static final int SIMPLE = 1;
    public static final int SIMPLE_NS = 2;
    public static final int DESCENDANT = 3;
    public static final int DESCENDANT_NS = 4;
    public static final int FOLLOWING = 5;
    public static final int FOLLOWING_NS = 6;
    public static final int PRECEDING = 7;
    public static final int PRECEDING_NS = 8;
    public static final int ATTR = 9;
    public static final int ATTR_NS = 10;
    public static final int NAME_SPACE = 11;
    private static Hashtable symbolHash;

    protected String getName() {
        return this.name;
    }

    public AutoPilot(VTDNav vTDNav) {
        if (vTDNav == null) {
            throw new IllegalArgumentException(" instance of VTDNav can't be null ");
        }
        this.name = null;
        this.vn = vTDNav;
        this.iter_type = 0;
        this.ft = true;
        this.size = 0;
        this.special = false;
        this.xpe = null;
        symbolHash = new Hashtable();
        this.fib = null;
    }

    public AutoPilot() {
        this.name = null;
        this.iter_type = 0;
        this.ft = true;
        this.size = 0;
        this.special = false;
        this.xpe = null;
        symbolHash = new Hashtable();
        this.fib = null;
    }

    public void declareXPathNameSpace(String string, String string2) {
        if (nsHash == null) {
            nsHash = new Hashtable();
        }
        nsHash.put(string, string2);
    }

    public void bind(VTDNav vTDNav) {
        this.name = null;
        if (vTDNav == null) {
            throw new IllegalArgumentException(" instance of VTDNav can't be null ");
        }
        this.vn = vTDNav;
        this.iter_type = 0;
        this.ft = true;
        this.size = 0;
        this.special = false;
    }

    public void declareVariableExpr(String string, String string2) throws XPathParseException {
        try {
            parser parser2 = new parser(new StringReader(string2));
            parser2.nsHash = nsHash;
            parser2.symbolHash = symbolHash;
            this.xpe = (Expr)parser2.parse().value;
            symbolHash.put(string, this.xpe);
            this.ft = true;
        }
        catch (XPathParseException xPathParseException) {
            System.out.println("Syntax error after or around the end of  ==>" + string2.substring(0, xPathParseException.getOffset()));
            throw xPathParseException;
        }
        catch (Exception exception) {
            throw new XPathParseException("Error occurred");
        }
    }

    public void clearVariableExprs() {
        symbolHash.clear();
    }

    public void clearXPathNameSpaces() {
        nsHash.clear();
    }

    public boolean iterate() throws PilotException, NavException {
        switch (this.iter_type) {
            case 1: {
                if (this.vn.atTerminal) {
                    return false;
                }
                if (!this.ft) {
                    return this.vn.iterate(this.depth, this.name, this.special);
                }
                this.ft = false;
                if (this.special || this.vn.matchElement(this.name)) {
                    return true;
                }
                return this.vn.iterate(this.depth, this.name, this.special);
            }
            case 2: {
                if (this.vn.atTerminal) {
                    return false;
                }
                if (!this.ft) {
                    return this.vn.iterateNS(this.depth, this.URL, this.localName);
                }
                this.ft = false;
                if (this.vn.matchElementNS(this.URL, this.localName)) {
                    return true;
                }
                return this.vn.iterateNS(this.depth, this.URL, this.localName);
            }
            case 3: {
                if (this.vn.atTerminal) {
                    return false;
                }
                return this.vn.iterate(this.depth, this.name, this.special);
            }
            case 4: {
                if (this.vn.atTerminal) {
                    return false;
                }
                return this.vn.iterateNS(this.depth, this.URL, this.localName);
            }
            case 5: {
                if (this.vn.atTerminal) {
                    return false;
                }
                if (!this.ft) {
                    return this.vn.iterate_following(this.name, this.special);
                }
                this.ft = false;
                do {
                    if (!this.vn.toElement(4)) continue;
                    if (this.special || this.vn.matchElement(this.name)) {
                        return true;
                    }
                    return this.vn.iterate_following(this.name, this.special);
                } while (this.vn.toElement(1));
                return false;
            }
            case 6: {
                if (this.vn.atTerminal) {
                    return false;
                }
                if (!this.ft) {
                    return this.vn.iterate_followingNS(this.URL, this.localName);
                }
                this.ft = false;
                do {
                    if (!this.vn.toElement(4)) continue;
                    if (this.vn.matchElementNS(this.URL, this.localName)) {
                        return true;
                    }
                    return this.vn.iterate_followingNS(this.URL, this.localName);
                } while (this.vn.toElement(1));
                return false;
            }
            case 7: {
                if (this.vn.atTerminal) {
                    return false;
                }
                return this.vn.iterate_preceding(this.name, this.contextCopy, this.special);
            }
            case 8: {
                if (this.vn.atTerminal) {
                    return false;
                }
                return this.vn.iterate_precedingNS(this.URL, this.localName, this.contextCopy);
            }
        }
        throw new PilotException(" iteration action type undefined");
    }

    protected int iterateNameSpace() throws PilotException, NavException {
        if (!this.vn.ns) {
            return -1;
        }
        if (this.ft) {
            this.ft = false;
            this.index = this.vn.getCurrentIndex2() + 1;
        } else {
            this.index += 2;
        }
        while (this.index < this.size) {
            int n = this.vn.getTokenType(this.index);
            if (n == 2 || n == 3) {
                if (n == 3 && (this.name.equals("*") || this.vn.matchRawTokenString(this.index, this.name2)) && this.checkNsUniqueness(this.index)) {
                    this.vn.LN = this.index;
                    this.vn.atTerminal = true;
                    return this.index;
                }
                this.index += 2;
                continue;
            }
            this.vn.atTerminal = false;
            if (!this.vn.toElement(1)) {
                return -1;
            }
            this.index = this.vn.getCurrentIndex2() + 1;
        }
        return -1;
    }

    protected boolean checkNsUniqueness(int n) throws NavException {
        for (int i = 0; i < this.fib.size(); ++i) {
            if (this.vn.compareTokens(this.fib.intAt(i), this.vn, n) != 0) continue;
            return false;
        }
        this.fib.append(n);
        return true;
    }

    protected int iterateAttr2() throws PilotException, NavException {
        switch (this.iter_type) {
            case 9: {
                if (this.name.compareTo("*") == 0) {
                    if (this.ft) {
                        this.ft = false;
                        this.index = this.vn.getCurrentIndex2() + 1;
                    } else {
                        this.index += 2;
                    }
                    if (!this.vn.ns) {
                        if (this.index < this.size) {
                            int n = this.vn.getTokenType(this.index);
                            if (n == 2 || n == 3) {
                                this.vn.LN = this.index;
                                return this.index;
                            }
                            return -1;
                        }
                        return -1;
                    }
                    while (this.index < this.size) {
                        int n = this.vn.getTokenType(this.index);
                        if (n == 2 || n == 3) {
                            if (n == 2) {
                                this.vn.LN = this.index;
                                return this.index;
                            }
                            this.index += 2;
                            continue;
                        }
                        return -1;
                    }
                    return -1;
                }
                if (!this.ft) {
                    return -1;
                }
                this.ft = false;
                int n = this.vn.getAttrVal(this.name);
                if (n != -1) {
                    this.vn.LN = n - 1;
                    return n - 1;
                }
                return -1;
            }
            case 10: {
                if (!this.ft) {
                    return -1;
                }
                this.ft = false;
                int n = this.vn.getAttrValNS(this.URL, this.localName);
                if (n != -1) {
                    this.vn.LN = n - 1;
                    return n - 1;
                }
                return -1;
            }
        }
        throw new PilotException("invalid iteration type");
    }

    public int iterateAttr() throws PilotException, NavException {
        switch (this.iter_type) {
            case 9: {
                if (this.name.compareTo("*") == 0) {
                    if (this.ft) {
                        this.ft = false;
                        this.index = this.vn.getCurrentIndex2() + 1;
                    } else {
                        this.index += 2;
                    }
                    if (!this.vn.ns) {
                        if (this.index < this.size) {
                            int n = this.vn.getTokenType(this.index);
                            if (n == 2 || n == 3) {
                                return this.index;
                            }
                            return -1;
                        }
                        return -1;
                    }
                    while (this.index < this.size) {
                        int n = this.vn.getTokenType(this.index);
                        if (n == 2 || n == 3) {
                            if (n == 2) {
                                return this.index;
                            }
                            this.index += 2;
                            continue;
                        }
                        return -1;
                    }
                    return -1;
                }
                if (!this.ft) {
                    return -1;
                }
                this.ft = false;
                int n = this.vn.getAttrVal(this.name);
                if (n != -1) {
                    return n - 1;
                }
                return -1;
            }
            case 10: {
                if (!this.ft) {
                    return -1;
                }
                this.ft = false;
                int n = this.vn.getAttrValNS(this.URL, this.localName);
                if (n != -1) {
                    return n - 1;
                }
                return -1;
            }
        }
        throw new PilotException("invalid iteration type");
    }

    public void selectElement(String string) {
        if (string == null) {
            throw new IllegalArgumentException("element name can't be null");
        }
        this.iter_type = 1;
        this.depth = this.vn.getCurrentDepth();
        this.name = string;
        this.ft = true;
    }

    public void selectElementNS(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("local name can't be null");
        }
        this.iter_type = 2;
        this.depth = this.vn.getCurrentDepth();
        this.localName = string2;
        this.URL = string;
        this.ft = true;
    }

    protected void selectElement_D(String string) {
        if (string == null) {
            throw new IllegalArgumentException("element name can't be null");
        }
        this.iter_type = 3;
        this.depth = this.vn.getCurrentDepth();
        this.name = string;
        this.ft = true;
    }

    protected void selectElementNS_D(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("local name can't be null");
        }
        this.iter_type = 4;
        this.depth = this.vn.getCurrentDepth();
        this.localName = string2;
        this.URL = string;
        this.ft = true;
    }

    protected void selectElement_F(String string) {
        if (string == null) {
            throw new IllegalArgumentException("element name can't be null");
        }
        this.iter_type = 5;
        this.ft = true;
        this.name = string;
    }

    protected void selectElementNS_F(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("local name can't be null");
        }
        this.iter_type = 6;
        this.ft = true;
        this.localName = string2;
        this.URL = string;
    }

    protected void selectElement_P(String string) {
        if (string == null) {
            throw new IllegalArgumentException("element name can't be null");
        }
        this.depth = this.vn.getCurrentDepth();
        this.iter_type = 7;
        this.ft = true;
        this.name = string;
        this.contextCopy = (int[])this.vn.context.clone();
        for (int i = this.vn.context[0] + 1; i < this.vn.context.length; ++i) {
            this.contextCopy[i] = -1;
        }
        this.contextCopy[0] = this.vn.rootIndex;
    }

    protected void selectElementNS_P(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("local name can't be null");
        }
        this.depth = this.vn.getCurrentDepth();
        this.iter_type = 8;
        this.ft = true;
        this.localName = string2;
        this.URL = string;
        this.contextCopy = (int[])this.vn.context.clone();
        for (int i = this.vn.context[0] + 1; i < this.vn.context.length; ++i) {
            this.vn.context[i] = -1;
        }
        this.contextCopy[0] = this.vn.rootIndex;
    }

    protected void selectNameSpace(String string) {
        if (string == null) {
            throw new IllegalArgumentException("namespace name can't be null");
        }
        this.iter_type = 11;
        this.ft = true;
        this.size = this.vn.getTokenCount();
        this.name = string;
        if (!string.equals("*")) {
            this.name2 = "xmlns:" + string;
        }
        if (this.fib == null) {
            this.fib = new FastIntBuffer(4);
        } else {
            this.fib.clear();
        }
    }

    public void selectAttr(String string) {
        if (string == null) {
            throw new IllegalArgumentException("attribute name can't be null");
        }
        this.iter_type = 9;
        this.ft = true;
        this.size = this.vn.getTokenCount();
        this.name = string;
    }

    public void selectAttrNS(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("local name of an attribute can't be null");
        }
        this.iter_type = 10;
        this.ft = true;
        this.localName = string2;
        this.URL = string;
    }

    public void selectXPath(String string) throws XPathParseException {
        try {
            parser parser2 = new parser(new StringReader(string));
            parser2.nsHash = nsHash;
            parser2.symbolHash = symbolHash;
            this.xpe = (Expr)parser2.parse().value;
            this.ft = true;
        }
        catch (XPathParseException xPathParseException) {
            System.out.println("Syntax error after or around the end of ==>" + string.substring(0, xPathParseException.getOffset()));
            throw xPathParseException;
        }
        catch (Exception exception) {
            throw new XPathParseException("Error occurred");
        }
    }

    public void resetXPath() {
        if (this.xpe != null && this.vn != null) {
            this.xpe.reset(this.vn);
            this.ft = true;
            this.vn.contextStack2.size = this.stackSize;
        }
    }

    public double evalXPathToNumber() {
        return this.xpe.evalNumber(this.vn);
    }

    public String evalXPathToString() {
        return this.xpe.evalString(this.vn);
    }

    public boolean evalXPathToBoolean() {
        return this.xpe.evalBoolean(this.vn);
    }

    public int evalXPath() throws XPathEvalException, NavException {
        if (this.xpe != null) {
            if (this.ft) {
                if (this.vn != null) {
                    this.stackSize = this.vn.contextStack2.size;
                }
                this.ft = false;
                this.xpe.adjust(this.vn.getTokenCount());
            }
            return this.xpe.evalNodeSet(this.vn);
        }
        throw new PilotException(" Null XPath expression ");
    }

    protected void setSpecial(boolean bl) {
        this.special = bl;
    }

    public String getExprString() {
        return this.xpe.toString();
    }
}

