/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended;

import com.ximpleware.extended.IByteBuffer;
import com.ximpleware.extended.ParseExceptionHuge;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class XMLBuffer
implements IByteBuffer {
    byte[][] bufferArray;
    long length;

    public XMLBuffer() {
    }

    public XMLBuffer(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("ba can't be null ");
        }
        if (byArray.length > 0x40000000) {
            throw new IllegalArgumentException("ba should be shorter than 1G bytes ");
        }
        this.bufferArray = new byte[1][];
        this.bufferArray[0] = byArray;
        this.length = byArray.length;
    }

    public void readFile(String string) throws IOException, ParseExceptionHuge {
        long l;
        File file = new File(string);
        this.length = l = file.length();
        if (l >= 0x4000000000L) {
            throw new ParseExceptionHuge("document too big > 256 Gbyte");
        }
        int n = (int)(l >> 30) + ((l & 0x3FFFFFFFL) == 0L ? 0 : 1);
        this.bufferArray = new byte[n][];
        FileInputStream fileInputStream = new FileInputStream(file);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (l > 0x40000000L) {
                this.bufferArray[i] = new byte[0x40000000];
                n2 = 0x40000000;
            } else {
                this.bufferArray[i] = new byte[(int)l];
                n2 = (int)l;
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0x100000;
            if (n2 - n3 < n5) {
                n5 = n2 - n3;
            }
            while (n3 < n2 && (n4 = fileInputStream.read(this.bufferArray[i], n3, n5)) >= 0) {
                if (n2 - (n3 += n4) >= n5) continue;
                n5 = n2 - n3;
            }
            l -= 0x40000000L;
        }
    }

    @Override
    public final byte byteAt(long l) {
        return this.bufferArray[(int)(l >> 30)][(int)(l & 0x3FFFFFFFL)];
    }

    @Override
    public byte[] getBytes(int n, int n2) {
        return null;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public byte[] getBytes() {
        return null;
    }

    @Override
    public void writeToFileOutputStream(FileOutputStream fileOutputStream, long l, long l2) throws IOException {
        int n = (int)(l >> 30);
        int n2 = (int)(l & 0x3FFFFFFFL);
        if ((long)n2 + l2 <= 0x40000000L) {
            fileOutputStream.write(this.bufferArray[n], n2, (int)l2);
            return;
        }
        fileOutputStream.write(this.bufferArray[n], n2, 0x40000000 - n2);
        ++n;
        l2 -= (long)(0x40000000 - n2);
        while (l2 > 0x40000000L) {
            fileOutputStream.write(this.bufferArray[n], 0, 0x40000000);
            ++n;
            l2 -= 0x40000000L;
        }
        fileOutputStream.write(this.bufferArray[n], 0, (int)l2);
    }
}

