function [y1] = BQ05_TS50TS(x1)
% BQ05_TS50TS is neural network simulation function.
% It predicts TI BQ25505 efficiency according to the input voltage and
% current in addition to the storage voltage.
% 
% [y] = BQ05_TS50TS(x) takes these arguments as:
%   x = [Vin, Vstr, Ii]'
%       Voltage values in V (Volt)
%       Current value in uA (micro Ampere)
% and returns:
%   y = efficiency (in percent)
% 
% This model has a single hidden layer including 50 neurons with tangent sigmoid transfer function 
% and  a single neuron tangent sigmoid transfer function output layer.

% Coperight: Mojtaba Masoudinejad, 2018, Dortmund
% mojtaba.masoudinejad@tu-dortmund.de

% ===== NEURAL NETWORK CONSTANTS =====

% Input 1
x1_step1.xoffset = [0.328;1.5999;0.5];
x1_step1.gain = [0.447727781508843;0.769201184569824;1.99005965203807e-05];
x1_step1.ymin = -1;

% Layer 1
b1 = [-0.26798705111173554139;106.12239740833570067;365.31607264841511551;24.375756680220906247;244.72555116380027584;3.9979654999399287796;-23.411444478524835233;611.24122507758943357;-41.562338253760152895;-147.31426451810614253;-0.25351462072845298845;1.9813553440296309827;159.3192380566544557;1.1830445700350995519;1034.49501476173009;720.13614139217384036;-511.77843901853043462;-11.088793432019674157;-256.8630194703835059;-271.17849544530753292;722.43661743169241163;71.892814325603026759;-1.4893500538486226237;41.945795282765480749;159.16870564391089715;78.919550306571053966;158.89005146603284402;1262.939018251124935;631.63543145646724497;-34.094478873428265331;72.021520909451709258;150.82899187685876541;-209.82041603520590911;-1.1549372544651768102;-78.174823249685488236;-162.11066183911020744;-107.82744164707877133;25.668247916886883786;3.449972168991990884;-154.17257769258415578;160.03159929526103156;-79.436448111643827019;754.33827268705204006;497.55502816556270318;71.310844082542701017;-296.36303057584729004;-479.32422350664614896;3.2156655178124542438;498.81636145038118002;-67.082193234549137628];
IW1_1 = [-1.9579433898741032127 1.1435746589402993045 0.25395419053099871354;-100.51968089450032551 -37.649452030380011536 142.72188459214120826;-0.85415602935473478041 -0.0073195443990320113031 362.76623513596445036;-67.362316345738548762 -1.316302638380302259 0.75373899381923914476;-2.7809540503614900153 66.394533181477740413 186.82647644938174381;3.9418625207671844635 0.08437397042786141943 0.16206908170083228482;64.696719734425030879 1.1774939870172367318 -0.75045515709287602402;0.051752794931574988557 -0.14484506187743792505 610.28405744403391964;7.9551724036477340363 -37.192935594938134614 -10.092593232182332841;241.33423506101152611 -128.12328119112035552 -189.16503639947120519;-1.9382867855276963986 1.138320353434721266 0.2496627781112556177;1.5250113494030024253 0.020525566530668525045 0.20126694653695983983;-25.642899078210806607 12.552189734058464055 160.76120681688567515;-7.4785457115865030531 4.085039458962351766 0.49099974266842744131;0.50660172713110374065 -0.38995851282362126167 1032.3168092769376472;4.828361311570835035 0.87816999154051356147 713.71035674022300554;-2.8043924210279151943 -0.71661378441487133539 -506.6502806552729794;-7.4676019522258272332 -0.075561415635716958072 1.7621482818939806503;71.948454288847628391 -69.879293372175354193 -227.6845642046930891;3.826428797895008227 -2.5373765328943105324 -273.06595217114426077;0.18879313297870450872 -0.15122878612311108082 721.77751653569259815;-67.526491326326791409 -25.020984049540906824 96.614319970840540464;-1.4533883119196719935 -0.020928745998472747525 -0.23033892663247340638;176.06485173446273507 17.158059056629539896 -19.727591542977954475;-51.082907498415899283 51.871397899605675264 137.41421612471290814;-1.3956358766251788506 -16.205930556012656751 62.679147750697026709;-25.578379540119641433 12.527139378309998463 160.32904388853691557;0.5713307545097485729 -0.49161898621324268133 1261.1981448210508461;3.9614693536606417901 0.8416756504212521417 625.77816245856922706;34.793063793822028629 -84.191380291991706031 -23.883829891049888516;17.644408487216548309 4.3585986708685409141 75.580192650302521429;-247.34756758115170783 131.26201526355256988 193.72883828241290871;58.673371723773470876 -135.00463384439694892 -133.74443380688913408;7.2942647482609368481 -3.975931316345511668 -0.50324453326652474061;-19.080248978043165664 -4.7760410117372922301 -81.994385364593568966;1.2805261787196373646 -2.5704324616798923664 -152.16025580799311001;52.281879619739129339 -38.742380916768468069 -110.79721718752782067;-70.939682750481679818 -1.4880059714555284867 0.76537689662964980553;-6.3415438299245288079 3.7960095569419411987 -3.6428585805568549638;253.03965167152998106 -134.23940558937226797 -198.0648272991664669;-51.373847654064135781 52.176948651553132663 138.15013508445824186;1.4036365555118719417 15.965509507037046077 -63.430323541890366812;0.30146596376210488266 -0.12076860508339744282 753.70881814591075454;-0.4743284094297632314 -0.15099637010706809526 498.30204142157913338;-43.634307652269562539 20.609875910168682367 76.320684745249366188;85.850977413466736721 -45.441264629920326001 -311.24674536915904355;117.44397015443733778 -99.691648231601931229 -447.77218539120741525;2.8362586826508375815 0.048888272496705333092 0.23687985887659562811;-0.46511378989766966052 -0.15098369403514905196 499.56222496466995153;89.795118440632847978 -14.552576437164105982 -142.60484510189513685];

% Layer 2
b2 = -109.80895318363882041;
LW2_1 = [-36.29699978100202884 -0.14335550274308461738 -180.31505259747851255 41.608875414332139542 50.392192867105812581 12.069055604485241062 23.073158220319065492 372.31233776286427428 95.185044915088226958 36.174744919141566868 36.907095868717057385 73.636889960975850045 25.965096641834527702 20.887223671406886183 705.38105683600201701 -131.96447760768433 349.23905269166834842 102.92465254262421581 1.0410158632198254214 0.029347735198827228781 -381.59507943913610006 0.15318899255235629564 27.979676562436928577 -0.013176131125411832609 155.98285166559693948 53.870154360694201046 -25.994395743911553609 -199.27134526551310501 352.4709523750311746 -0.0057699089080503820903 0.68800286231242546719 79.377271541853673398 -0.035448107866130770804 20.974579024769617774 0.65895647820832103925 98.317981852386381547 -0.033817091209805388852 -18.553139787563388552 -0.032771771886127294693 43.188281332599501638 -154.57765440437054849 52.759304747035031369 153.91131535529498819 182.19783881679393289 0.10370029192290708409 0.026934902689549438531 0.25582057445759387448 -40.774209327442001438 -185.77081609143107244 0.013663532990257430677];

% Output 1
y1_step1.ymin = -1;
y1_step1.gain = 0.0200002226111087;
y1_step1.xoffset = 2.37595156899639e-05;

% ===== SIMULATION ========

% Dimensions
Q = size(x1,2); % samples

% Input 1
xp1 = mapminmax_apply(x1,x1_step1);

% Layer 1
a1 = tansig_apply(repmat(b1,1,Q) + IW1_1*xp1);

% Layer 2
a2 = tansig_apply(repmat(b2,1,Q) + LW2_1*a1);

% Output 1
y1 = mapminmax_reverse(a2,y1_step1);
end

% ===== MODULE FUNCTIONS ========

% Map Minimum and Maximum Input Processing Function
function y = mapminmax_apply(x,settings)
  y = bsxfun(@minus,x,settings.xoffset);
  y = bsxfun(@times,y,settings.gain);
  y = bsxfun(@plus,y,settings.ymin);
end

% Sigmoid Symmetric Transfer Function
function a = tansig_apply(n,~)
  a = 2 ./ (1 + exp(-2*n)) - 1;
end

% Map Minimum and Maximum Output Reverse-Processing Function
function x = mapminmax_reverse(y,settings)
  x = bsxfun(@minus,y,settings.ymin);
  x = bsxfun(@rdivide,x,settings.gain);
  x = bsxfun(@plus,x,settings.xoffset);
end
