package user;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;

import communication.CqeType;
import communication.CqeType.Right;

/**
 * Repraesentiert eine Rolle, die aus einer Menge von Rechten besteht.
 * Da kein direktes Erben von EnumSet moeglich ist, wurde hier von AbstractSet
 * geerbt und per Delegation alle Methoden an EnumSet weitergegeben (automatisch
 * generierter Code).
 *
 */
public class Role extends AbstractSet<Right> implements Serializable, Cloneable {
	private static final long serialVersionUID = -5363448735266888578L;
	
	private EnumSet<Right> rights;
	private String name;
	private int roleId;
	
	public Role( ) {
		this("");
	}
	
	public Role( String name ) {
		this( -1, name );
	}
	
	public Role( int roleId, String name ) {
		this( name, EnumSet.noneOf(Right.class) );
		this.roleId = roleId;
	}
	
	public Role( EnumSet<Right> rights ) {
		this( "", rights );
	}
	
	public Role( String name, EnumSet<Right> rights ) {
		this.name = name;
		this.rights = rights;
	}
	
	public void setName( String name ) {
		this.name = name;
	}
	
	public String getName( ) {
		return this.name;
	}
	
	public EnumSet<Right> getRights() {
		return this.rights;
	}
	
	public int getRoleId() {
		return this.roleId;
	}
	
	/**
	 * Fuegt ein Recht mit dem angegebenen Namen hinzu. Die Namen der Rechte entsprechen den Konstantenbezeichnern in der Klasse CqeType.Right.
	 * @param right Name des Rechts.
	 * @return True, falls das Recht hinzugefuegt werden konnte, sonst false.
	 */
	public boolean add( String right ) {
		return this.add( CqeType.Right.stringToRight(right) );
	}

	/**
	 * @param e
	 * @return
	 * @see java.util.AbstractCollection#add(java.lang.Object)
	 */
	public boolean add(Right e) {
		return rights.add(e);
	}

	/**
	 * @param c
	 * @return
	 * @see java.util.AbstractCollection#addAll(java.util.Collection)
	 */
	public boolean addAll(Collection<? extends Right> c) {
		return rights.addAll(c);
	}

	/**
	 * 
	 * @see java.util.AbstractCollection#clear()
	 */
	public void clear() {
		rights.clear();
	}

	/**
	 * @return
	 * @see java.util.EnumSet#clone()
	 */
	public EnumSet<Right> clone() {
		return rights.clone();
	}

	/**
	 * @param o
	 * @return
	 * @see java.util.AbstractCollection#contains(java.lang.Object)
	 */
	public boolean contains(Object o) {
		return rights.contains(o);
	}

	/**
	 * @param c
	 * @return
	 * @see java.util.AbstractCollection#containsAll(java.util.Collection)
	 */
	public boolean containsAll(Collection<?> c) {
		return rights.containsAll(c);
	}

	/**
	 * @param o
	 * @return
	 * @see java.util.AbstractSet#equals(java.lang.Object)
	 */
	public boolean equals(Object o) {
		
		if (o instanceof Role) {
			Role e = (Role)o;
			return e.getRoleId() == roleId;
		}
		
		return false;
		
	}

	/**
	 * @return
	 * @see java.util.AbstractSet#hashCode()
	 */
	public int hashCode() {
		return rights.hashCode();
	}

	/**
	 * @return
	 * @see java.util.AbstractCollection#isEmpty()
	 */
	public boolean isEmpty() {
		return rights.isEmpty();
	}

	/**
	 * @return
	 * @see java.util.AbstractCollection#iterator()
	 */
	public Iterator<Right> iterator() {
		return rights.iterator();
	}

	/**
	 * @param o
	 * @return
	 * @see java.util.AbstractCollection#remove(java.lang.Object)
	 */
	public boolean remove(Object o) {
		return rights.remove(o);
	}

	/**
	 * @param c
	 * @return
	 * @see java.util.AbstractSet#removeAll(java.util.Collection)
	 */
	public boolean removeAll(Collection<?> c) {
		return rights.removeAll(c);
	}

	/**
	 * @param c
	 * @return
	 * @see java.util.AbstractCollection#retainAll(java.util.Collection)
	 */
	public boolean retainAll(Collection<?> c) {
		return rights.retainAll(c);
	}

	/**
	 * @return
	 * @see java.util.AbstractCollection#size()
	 */
	public int size() {
		return rights.size();
	}

	/**
	 * @return
	 * @see java.util.AbstractCollection#toArray()
	 */
	public Object[] toArray() {
		return rights.toArray();
	}

	/**
	 * @param <T>
	 * @param a
	 * @return
	 * @see java.util.AbstractCollection#toArray(T[])
	 */
	public <T> T[] toArray(T[] a) {
		return rights.toArray(a);
	}

	public String toString() {
		return this.getName();
	}
	
}
