package server.theoremprover;

import exception.ProverException;

public class ProverNineResult extends ProverResult {

	public ProverNineResult(boolean result, String output) {
		super(result, output);
	}
	
	@Override
	public String getProof() throws ProverException {
		int start = output.indexOf("============================== PROOF =================================");
		int end = output.indexOf("============================== end of proof ==========================");
		if( start == -1 || end == -1 ) {
			// no proof found
			throw new ProverException("No proof found.", null);
		}
		
		return output.substring(start + 72, end - 2);
	}
	
	@Override
	public String getProofAsXML() throws ProverException {
		String proof = this.getProof();
		
		// transform proof into XML using prooftrans
		// FIXME: implement me
		
		String xmlProof = "";
		return null;
	}

}
