package server.parser.node;

import java.util.HashSet;
import java.util.Set;

import server.parser.Formatter.FormulaFormatter;

public class RelationnameNode extends Node {
	private static final long serialVersionUID = 856085224775109863L;
	
	String relationName;

	public RelationnameNode(String relationname) {
		this.setRelationname( relationname );
	}
	
	public String getRelationname() {
		return this.relationName;
	}
	
	public void setRelationname( String relationname ) {
		this.relationName = relationname;
	}
	
	@Override
	public boolean isRelationnameNode() {
		return true;
	}

	@Override
	public String toString(FormulaFormatter formulaformatter) {
		// FIXME
		return "";
	}
	
	/**
     * Gibt die Menge aller Relationennamen zurueck, die in diesem Baum vorkommen.
     * 
     * @return Die Menge aller Relationennamen dieses (Teil-)Baums.
     */
	@Override
	public Set<String> getRelationnames() {
		Set<String> ret = new HashSet<String>();
		ret.add(this.getRelationname());
		return ret;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result
				+ ((relationName == null) ? 0 : relationName.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		RelationnameNode other = (RelationnameNode) obj;
		if (relationName == null) {
			if (other.relationName != null)
				return false;
		} else if (!relationName.equals(other.relationName))
			return false;
		return true;
	}
}
