package server.parser.node;

import java.util.List;
import java.util.Set;

import exception.UnsupportedFormulaException;

import server.parser.Formatter.FormulaFormatter;


public class ExistentialQuantifiedNode extends QuantifiedNode {
	private static final long serialVersionUID = -823154378847152242L;

	public ExistentialQuantifiedNode(List<VariableNode> quantifiedVariables, Node quantifyingFormula) {
		super(quantifiedVariables, quantifyingFormula);
	}

	@Override
	public boolean isExistentialQuantifiedNode() {
		return true;
	}

	@Override
	public String getQuantor(FormulaFormatter formatter) {
		return formatter.getExistialQuantor();
	}
	
	@Override
	public Set<String> rr() {
		Set<String> rr = getQuantifiedFormula().rr();
		Set<String> vars = this.getQuantifiedVariables();
		
		// rr != null erforderlich, da rr der quantifiedFormula nicht definiert/bottom (=null) sein kann
		if ( rr != null && rr.containsAll(vars) ) {
			rr.removeAll( vars );
			return rr;
		} else {
			return null;
		}
	}
	
	@Override
	protected void pushNegations( boolean foundNegation, boolean skipNegatedExistentialQuantifiers ) throws UnsupportedFormulaException {
		if( skipNegatedExistentialQuantifiers && foundNegation ) {
			// Negation vorher gefunden, Quantorumwandlung in All-Quantor nicht erlaubt
			// -> Negation vor Existenzquantor einfuegen
			Node parent = this.getParent();
			NegationNode neg = new NegationNode(this);
			parent.replaceChild(this, neg);
			foundNegation = false;
		}
		else if( foundNegation ) {
			// Negation vor Existenzquantor => Allquantor
			UniversalQuantifiedNode forall = new UniversalQuantifiedNode( this.getVariableNodes(), this.getQuantifiedFormula() );
			this.getParent().replaceChild(this, forall);
		}
		
		// Rekursiver Aufruf
		for ( Node child : this.getChildren() ) {
			child.pushNegations(foundNegation, skipNegatedExistentialQuantifiers);
		}
	}
}
