package server.parser.languagetypes;

import java.util.HashSet;
import java.util.Set;

import server.parser.node.Node;

/**
 * Ueberprueft, ob die Formel offen (Typ: open) oder geschlossen (Typ: closed)
 * ist. Dazu wird nur die Menge der freien Variablen betrachtet. D.h. z.B. auch,
 * dass aussagelogische Formeln immer den Typ closed erfuellen.
 * 
 */
public class OpenClosedLTParser extends LanguageTypeParser {

	@Override
	public Set<String> parseLanguageTypes( Node tree ) {
		HashSet<String> types = new HashSet<String>();
		
		if ( tree.getFreeVariables().isEmpty() ) {
			types.add( "closed" );
		} else {
			types.add( "open" );
		}
		
		return types;
	}

}
