package server.parser.languagetypes;

import java.util.Set;

import server.parser.node.Node;

/**
 * Diese Klasse ist die abstrakte Basisklasse fuer alle Klassen, die sich mit dem Parsen
 * von LanguageTypes beschaeftigen. Die Idee ist, dass auf Kosten der Geschwindigkeit
 * die Uebersichtlichkeit des Programms erhoeht wird, indem das Bestimmen der
 * LanguageTypes auf mehrere Klassen aufgeteilt wird. Diese Klassen pruefen dann nur
 * auf eine bestimmte Auswahl von LanguageTypes.
 * 
 * Jeder LanguageType ist ein einfacher String. Dieser String kann dann in der
 * Definition des Automaten verwendet werden. Deshalb sollte jede LanguageType-
 * Klasse leicht auffindbar die bereitgestellten Strings anzeigen (z.B.
 * JavaDoc der Klasse).
 * 
 */
public abstract class LanguageTypeParser {
	/**
	 * Dies ist die zentrale Methode, die jeder LanguageType-Parser implementieren muss.
	 * Ziel dieser Methode soll sein den als Parameter uebergebenen Baum auf bestimmte
	 * LanguageTypes hin zu ueberpruefen. Welche LanguageTypes dies sind, haengt von
	 * der implementierenden Klasse ab. Als Ergebnis wird eine Menge von LanguageTypes
	 * zurueckgeliefert, die dieser Baum erfuellt. Dadurch kann durchaus eine Klasse
	 * den Baum auf mehrere LanguageTypes gleichzeitig hin untersuchen, um ggf.
	 * Arbeit zu sparen.
	 * 
	 * Um eine Menge aller vom Baum erfuellenden LanguageTypes zu erhalten muss iterativ
	 * jeder LanguageType-Parser ausgefuehrt werden und am Ende die Vereinigung aller
	 * Mengen gebildet werden. Dieser Schritt passiert in der Methode getLanguageTypes()
	 * in der Klasse Formula.
	 * 
	 * @return Eine Menge von LanguageTypes, die von der implementierenden Klasse untersucht wird.
	 * @see server.parser.node.Formula.getLanguageTypes()
	 */
	public abstract Set<String> parseLanguageTypes( Node tree );
}
